/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;

public class Generator
extends WFApplet
implements Runnable,
ItemListener,
ActionListener,
AdjustmentListener {
    final WFApplet appl = this;
    int width0;
    Font fH;
    Color BG = Color.yellow;
    Color PAN = Color.green;
    Color BLACK = Color.black;
    Color COL_B = Color.blue;
    Color COL_I = Color.red;
    Color COL_U = Color.blue;
    Color COL_NP = Color.red;
    Color COL_SP = Color.green;
    int x0;
    int y0;
    int x1;
    int y1;
    Canvas1 cv;
    GBLJPanel p;
    JButton bOn;
    JButton bR;
    JRadioButton rbMK;
    JRadioButton rbOK;
    JCheckBox cb1;
    JCheckBox cb2;
    JCheckBox cb3;
    JScrollBar scr;
    JLabel lDrZ;
    Polygon p1;
    Polygon p2;
    Polygon p3;
    Polygon p4;
    Polygon p5;
    Polygon p6;
    Polygon p7;
    Polygon p8;
    Polygon pW;
    Polygon pVM1;
    Polygon pVM2;
    double T;
    double t;
    boolean on;
    boolean current;
    int direction;
    double phi;
    double cos;
    double sin;
    int nMax;
    Thread thr;
    boolean genDC;
    boolean vArrows;
    boolean bArrows;
    boolean iArrows;
    final double PI = Math.PI;
    final double PI2 = Math.PI * 2;
    final double PIH = 1.5707963267948966;

    public void start() {
        int n;
        super.start();
        this.fH = new Font("Helvetica", 1, 12);
        this.cp.setLayout(null);
        this.p1 = new Polygon();
        this.p1.addPoint(213, 307);
        this.p1.addPoint(25, 260);
        this.p1.addPoint(25, 160);
        this.p1.addPoint(65, 170);
        this.p1.addPoint(110, 160);
        this.p1.addPoint(110, 235);
        this.p1.addPoint(263, 272);
        this.p1.addPoint(263, 297);
        this.p1.addPoint(213, 307);
        this.p2 = new Polygon();
        this.p2.addPoint(213, 132);
        this.p2.addPoint(110, 105);
        this.p2.addPoint(110, 160);
        this.p2.addPoint(65, 170);
        this.p2.addPoint(25, 160);
        this.p2.addPoint(25, 60);
        this.p2.addPoint(75, 50);
        this.p2.addPoint(263, 97);
        this.p2.addPoint(263, 120);
        this.p2.addPoint(213, 132);
        this.p3 = new Polygon();
        for (n = 0; n < 4; ++n) {
            this.p3.addPoint(0, 0);
        }
        this.p4 = new Polygon();
        for (n = 0; n < 4; ++n) {
            this.p4.addPoint(0, 0);
        }
        this.p5 = new Polygon();
        this.p5.addPoint(241, 185);
        this.p5.addPoint(249, 187);
        this.p5.addPoint(259, 185);
        this.p5.addPoint(259, 175);
        this.p5.addPoint(251, 173);
        this.p5.addPoint(241, 175);
        this.p5.addPoint(241, 185);
        this.p6 = new Polygon();
        this.p6.addPoint(241, 235);
        this.p6.addPoint(249, 237);
        this.p6.addPoint(259, 235);
        this.p6.addPoint(259, 225);
        this.p6.addPoint(251, 223);
        this.p6.addPoint(241, 225);
        this.p6.addPoint(241, 235);
        this.p7 = new Polygon();
        this.p7.addPoint(265, 241);
        this.p7.addPoint(273, 243);
        this.p7.addPoint(283, 241);
        this.p7.addPoint(283, 231);
        this.p7.addPoint(275, 229);
        this.p7.addPoint(265, 231);
        this.p7.addPoint(265, 241);
        this.p8 = new Polygon();
        for (n = 0; n < 4; ++n) {
            this.p8.addPoint(0, 0);
        }
        this.pW = new Polygon();
        this.pW.addPoint(288, 267);
        this.pW.addPoint(325, 260);
        this.pW.addPoint(325, 280);
        this.pW.addPoint(288, 287);
        this.pVM1 = new Polygon();
        this.pVM1.addPoint(358, 287);
        this.pVM1.addPoint(398, 297);
        this.pVM1.addPoint(498, 277);
        this.pVM1.addPoint(498, 227);
        this.pVM1.addPoint(398, 247);
        this.pVM1.addPoint(398, 147);
        this.pVM1.addPoint(498, 127);
        this.pVM1.addPoint(458, 117);
        this.pVM1.addPoint(358, 137);
        this.pVM1.addPoint(358, 287);
        this.pVM2 = new Polygon();
        this.pVM2.addPoint(398, 247);
        this.pVM2.addPoint(498, 227);
        this.pVM2.addPoint(498, 127);
        this.pVM2.addPoint(398, 147);
        this.pVM2.addPoint(398, 247);
        if ("German".equals("Polish")) {
            this.COL_NP = Color.blue;
            this.COL_SP = Color.red;
            this.COL_B = new Color(0, 128, 0);
        }
        this.T = 10.0;
        this.t = 0.0;
        this.current = true;
        this.on = true;
        this.direction = 1;
        this.phi = 0.0;
        this.cos = 1.0;
        this.sin = 0.0;
        this.nMax = 5;
        this.genDC = false;
        this.iArrows = true;
        this.bArrows = true;
        this.vArrows = true;
        this.width0 = 540;
        this.cv = new Canvas1();
        this.cv.setBackground(this.BG);
        this.cv.setBounds(0, 0, this.width0, this.height);
        this.cp.add(this.cv);
        this.p = new GBLJPanel(this.PAN);
        this.p.setBounds(this.width0, 0, this.width - this.width0, this.height);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rbOK = new JRadioButton(this.text(2), true);
        buttonGroup.add(this.rbOK);
        this.p.add((JComponent)this.rbOK, this.PAN, 0, 10, 0);
        this.rbMK = new JRadioButton(this.text(3), false);
        buttonGroup.add(this.rbMK);
        this.p.add((JComponent)this.rbMK, this.PAN, 1, 0, 0);
        this.bR = new JButton(this.text(4));
        this.p.add((JComponent)this.bR, Color.red, 2, 10, 0);
        this.scr = new JScrollBar(0, 5, 2, 0, 12);
        this.scr.setBlockIncrement(5);
        this.p.add((JComponent)this.scr, Color.white, 3, 10, 0);
        this.lDrZ = new JLabel();
        this.p.add((JComponent)this.lDrZ, this.PAN, 4, 0, 0);
        this.bOn = new JButton(this.text(6));
        this.p.add((JComponent)this.bOn, Color.magenta, 5, 10, 0);
        this.cb1 = new JCheckBox(this.text(7));
        this.cb1.setSelected(this.vArrows);
        this.p.add((JComponent)this.cb1, this.PAN, this.BLACK, 6, 10, 0);
        this.cb2 = new JCheckBox(this.text(8));
        this.cb2.setSelected(this.bArrows);
        this.p.add((JComponent)this.cb2, this.PAN, this.COL_B, 7, 0, 0);
        this.cb3 = new JCheckBox(this.text(9));
        this.cb3.setSelected(this.iArrows);
        this.p.add((JComponent)this.cb3, this.PAN, this.COL_I, 8, 0, 0);
        this.p.add((JComponent)new JLabel(this.text(10)), this.PAN, 9, 10, 0);
        this.p.add((JComponent)new JLabel(this.text(11)), this.PAN, 10, 0, 10);
        this.cp.add((Component)this.p);
        this.p.repaint();
        this.bR.addActionListener(this);
        this.bOn.addActionListener(this);
        this.rbOK.addItemListener(this);
        this.rbMK.addItemListener(this);
        this.cb1.addItemListener(this);
        this.cb2.addItemListener(this);
        this.cb3.addItemListener(this);
        this.scr.addAdjustmentListener(this);
        this.thr = new Thread(this);
        this.thr.start();
    }

    public void stop() {
        this.thr = null;
        this.cp.removeAll();
    }

    public void run() {
        long l = System.currentTimeMillis();
        this.p.repaint();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l2 = System.currentTimeMillis();
            if (this.on && this.T > 0.0) {
                double d = (double)(l2 - l) / 1000.0;
                this.t += d;
                this.phi += (double)this.direction * d * (Math.PI * 2) / this.T;
                int n = (int)(this.phi / (Math.PI * 2));
                this.phi = this.phi >= 0.0 ? (this.phi -= (double)n * (Math.PI * 2)) : (this.phi -= (double)(n - 1) * (Math.PI * 2));
                if (this.t > (double)this.nMax * this.T) {
                    this.t -= (double)this.nMax * this.T;
                }
                this.cos = Math.cos(this.phi);
                this.sin = Math.sin(this.phi);
            }
            l = l2;
        }
    }

    void magnet(Graphics graphics) {
        graphics.setColor(this.COL_SP);
        graphics.fillPolygon(this.p1);
        graphics.setColor(this.COL_NP);
        graphics.fillPolygon(this.p2);
        graphics.setColor(this.BLACK);
        graphics.drawPolygon(this.p1);
        graphics.drawPolygon(this.p2);
        graphics.drawLine(263, 272, 213, 282);
        graphics.drawLine(213, 282, 213, 307);
        graphics.drawLine(213, 282, 65, 245);
        graphics.drawLine(110, 235, 65, 245);
        graphics.drawLine(263, 97, 213, 107);
        graphics.drawLine(213, 107, 213, 132);
        graphics.drawLine(213, 107, 25, 60);
        graphics.drawLine(110, 105, 65, 95);
        graphics.drawLine(65, 95, 65, 245);
    }

    void moveTo(double d, double d2, double d3) {
        double d4 = d * this.cos - d3 * this.sin;
        double d5 = d * this.sin + d3 * this.cos;
        this.x0 = (int)Math.round(250.0 + 0.5 * d4 - 0.4 * d2);
        this.y0 = (int)Math.round(205.0 - 0.1 * d4 - 0.1 * d2 - 0.5 * d5);
    }

    void lineTo(Graphics graphics, int n, int n2) {
        this.x1 = n;
        this.y1 = n2;
        this.line(graphics, 3.0f, this.x0, this.y0, this.x1, this.y1);
        this.x0 = this.x1;
        this.y0 = this.y1;
    }

    void lineTo(Graphics graphics, double d, double d2, double d3) {
        double d4 = d * this.cos - d3 * this.sin;
        double d5 = d * this.sin + d3 * this.cos;
        this.x1 = (int)Math.round(250.0 + 0.5 * d4 - 0.4 * d2);
        this.y1 = (int)Math.round(205.0 - 0.1 * d4 - 0.1 * d2 - 0.5 * d5);
        this.line(graphics, 3.0f, this.x0, this.y0, this.x1, this.y1);
        this.x0 = this.x1;
        this.y0 = this.y1;
    }

    void arrowTo(Graphics graphics, int n, int n2) {
        double d = 0.2;
        double d2 = 10.0;
        double d3 = this.x0 - n;
        double d4 = n2 - this.y0;
        this.lineTo(graphics, n, n2);
        double d5 = Math.atan2(d4, d3);
        this.x0 = (int)Math.round((double)this.x1 + d2 * Math.cos(d5 + d));
        this.y0 = (int)Math.round((double)this.y1 - d2 * Math.sin(d5 + d));
        this.line(graphics, 3.0f, this.x0, this.y0, this.x1, this.y1);
        this.x0 = (int)Math.round((double)this.x1 + d2 * Math.cos(d5 - d));
        this.y0 = (int)Math.round((double)this.y1 - d2 * Math.sin(d5 - d));
        this.line(graphics, 3.0f, this.x0, this.y0, this.x1, this.y1);
        this.x0 = this.x1;
        this.y0 = this.y1;
    }

    void arrowTo(Graphics graphics, double d, double d2, double d3) {
        int n = this.x0;
        int n2 = this.y0;
        this.lineTo(graphics, d, d2, d3);
        this.x0 = n;
        this.y0 = n2;
        this.arrowTo(graphics, this.x1, this.y1);
    }

    void armature(Graphics graphics, int n) {
        double d;
        int n2 = 0;
        int n3 = 3 - 2 * n;
        double d2 = d = this.genDC ? 0.3 : 0.0;
        if (this.phi < 1.5707963267948966 - d || this.phi > 4.71238898038469 + d) {
            n2 = this.direction;
        }
        if (this.phi > 1.5707963267948966 + d && this.phi < 4.71238898038469 - d) {
            n2 = -this.direction;
        }
        graphics.setColor(this.current ? this.COL_I : this.BLACK);
        this.moveTo(0.0, 0.0, n3 * 10);
        this.lineTo(graphics, 0.0, 120.0, n3 * 10);
        this.lineTo(graphics, 0.0, 120.0, n3 * 80);
        this.lineTo(graphics, 0.0, 280.0, n3 * 80);
        this.lineTo(graphics, 0.0, 280.0, 0.0);
        if (this.iArrows && n2 != 0 && this.T > 0.0) {
            this.moveTo(0.0, 200.0, n3 * 80);
            this.arrowTo(graphics, 0.0, 200 - n3 * n2 * 40, n3 * 80);
        }
    }

    void setPoint(Polygon polygon, int n, double d, double d2, double d3) {
        double d4 = d * this.cos - d3 * this.sin;
        double d5 = d * this.sin + d3 * this.cos;
        polygon.xpoints[n] = (int)Math.round(250.0 + 0.5 * d4 - 0.4 * d2);
        polygon.ypoints[n] = (int)Math.round(205.0 - 0.1 * d4 - 0.1 * d2 - 0.5 * d5);
    }

    void commutator(Graphics graphics) {
        graphics.setColor(this.current ? this.COL_I : Color.lightGray);
        graphics.fillOval(234, 186, 40, 40);
        graphics.fillOval(226, 184, 40, 40);
        graphics.setColor(this.BLACK);
        graphics.drawOval(234, 186, 40, 40);
        graphics.drawArc(226, 184, 40, 40, 70, 200);
        double d = 40.0 - 4.0 * Math.sin(2.0 * this.phi);
        double d2 = d * Math.cos(0.25);
        double d3 = d * Math.sin(0.25);
        this.setPoint(this.p3, 0, d2, -10.0, d3);
        this.setPoint(this.p3, 1, -d2, -10.0, d3);
        this.setPoint(this.p3, 2, -d2, -10.0, -d3);
        this.setPoint(this.p3, 3, d2, -10.0, -d3);
        graphics.fillPolygon(this.p3);
        if (this.phi < 1.5707963267948966 || this.phi > 4.71238898038469) {
            d2 = -d2;
            d3 = -d3;
        }
        this.setPoint(this.p4, 0, d2, -10.0, d3);
        this.setPoint(this.p4, 1, d2, -10.0, -d3);
        this.setPoint(this.p4, 2, d2, 10.0, -d3);
        this.setPoint(this.p4, 3, d2, 10.0, d3);
        graphics.fillPolygon(this.p4);
    }

    void leftRing(Graphics graphics) {
        graphics.setColor(this.COL_I);
        graphics.fillOval(234, 186, 40, 40);
        graphics.fillOval(226, 184, 40, 40);
        graphics.setColor(this.BLACK);
        graphics.fillOval(239, 191, 30, 30);
        graphics.setColor(this.BG);
        graphics.fillArc(239, 191, 30, 30, 70, 180);
        graphics.fillArc(231, 189, 30, 30, 280, 120);
        graphics.setColor(this.COL_I);
        this.moveTo(0.0, 40.0, 10.0);
        this.lineTo(graphics, 0.0, 0.0, 10.0);
        this.lineTo(graphics, 0.0, 0.0, 30.0);
        this.moveTo(0.0, 40.0, -10.0);
        this.lineTo(graphics, 0.0, -40.0, -10.0);
        graphics.setColor(this.BLACK);
        graphics.drawOval(234, 186, 40, 40);
        graphics.drawArc(226, 184, 40, 40, 70, 200);
        graphics.drawOval(239, 191, 30, 30);
        int n = (int)Math.round(254.0 - 17.5 * this.sin);
        int n2 = (int)Math.round(206.0 - 17.5 * this.cos);
        graphics.setColor(Color.white);
        graphics.fillOval(n - 1, n2 - 1, 3, 3);
    }

    void rightRing(Graphics graphics) {
        graphics.setColor(this.COL_I);
        graphics.fillOval(258, 192, 40, 40);
        graphics.fillOval(250, 190, 40, 40);
        graphics.setColor(this.BLACK);
        graphics.fillOval(263, 197, 30, 30);
        graphics.setColor(this.BG);
        graphics.fillArc(263, 197, 30, 30, 70, 180);
        graphics.fillArc(255, 195, 30, 30, 280, 120);
        graphics.setColor(this.COL_I);
        this.moveTo(0.0, -20.0, -10.0);
        this.lineTo(graphics, 0.0, -60.0, -10.0);
        this.lineTo(graphics, 0.0, -60.0, -30.0);
        graphics.setColor(this.BLACK);
        graphics.drawOval(258, 192, 40, 40);
        graphics.drawArc(250, 190, 40, 40, 70, 200);
        graphics.drawOval(263, 197, 30, 30);
        int n = (int)Math.round(278.0 - 17.5 * this.sin);
        int n2 = (int)Math.round(212.0 - 17.5 * this.cos);
        graphics.setColor(Color.white);
        graphics.fillOval(n - 1, n2 - 1, 3, 3);
    }

    void crank(Graphics graphics, int n) {
        int n2 = (int)Math.round(250.0 - 0.4 * (double)n);
        int n3 = (int)Math.round(205.0 - 0.1 * (double)n);
        graphics.setColor(Color.orange);
        graphics.fillOval(n2 - 20, n3 - 20, 40, 40);
        graphics.fillOval(n2 - 28, n3 - 22, 40, 40);
        graphics.setColor(this.BLACK);
        graphics.drawOval(n2 - 20, n3 - 20, 40, 40);
        graphics.drawArc(n2 - 28, n3 - 22, 40, 40, 70, 200);
        int n4 = (int)Math.round((double)n2 - 15.0 * this.sin);
        int n5 = (int)Math.round((double)n3 - 15.0 * this.cos);
        this.p8.xpoints[0] = n4;
        this.p8.ypoints[0] = n5 - 2;
        this.p8.xpoints[1] = n4;
        this.p8.ypoints[1] = n5 + 2;
        this.p8.xpoints[2] = n4 + 16;
        this.p8.ypoints[2] = n5 + 6;
        this.p8.xpoints[3] = n4 + 16;
        this.p8.ypoints[3] = n5 + 2;
        graphics.setColor(Color.orange);
        graphics.fillPolygon(this.p8);
        graphics.fillOval(n4 + 14, n5 + 2, 5, 5);
        graphics.setColor(this.BLACK);
        graphics.drawLine(n4, n5 - 2, n4 + 16, n5 + 2);
        graphics.drawLine(n4, n5 + 2, n4 + 16, n5 + 6);
        graphics.drawArc(n4 - 2, n5 - 2, 5, 5, 90, 180);
        graphics.drawOval(n4 + 14, n5 + 2, 5, 5);
    }

    void contact1(Graphics graphics) {
        graphics.setColor(this.current ? this.COL_I : Color.lightGray);
        graphics.fillPolygon(this.p5);
        graphics.setColor(this.BLACK);
        graphics.drawPolygon(this.p5);
        graphics.drawLine(249, 177, 249, 187);
        graphics.drawLine(249, 177, 241, 175);
        graphics.drawLine(249, 177, 259, 175);
    }

    void contact2(Graphics graphics) {
        graphics.setColor(this.current ? this.COL_I : Color.lightGray);
        graphics.fillPolygon(this.p6);
        graphics.setColor(this.BLACK);
        graphics.drawPolygon(this.p6);
        graphics.drawLine(249, 227, 249, 237);
        graphics.drawLine(249, 227, 241, 225);
        graphics.drawLine(249, 227, 259, 225);
    }

    void contact3(Graphics graphics) {
        graphics.setColor(this.COL_I);
        graphics.fillPolygon(this.p7);
        graphics.setColor(this.BLACK);
        graphics.drawPolygon(this.p7);
        graphics.drawLine(273, 233, 273, 243);
        graphics.drawLine(273, 233, 265, 231);
        graphics.drawLine(273, 233, 283, 231);
    }

    void voltmeter(Graphics graphics, double d) {
        double d2 = 0.4;
        double d3 = 200.0;
        if (!this.current) {
            d = 0.0;
        }
        graphics.setColor(Color.white);
        graphics.fillPolygon(this.pVM2);
        graphics.setColor(this.BLACK);
        this.line(graphics, 3.0f, 407.0, 173.0, 404.0, 167.0);
        this.line(graphics, 3.0f, 427.0, 163.0, 426.0, 156.0);
        graphics.drawString("0", 444, 158);
        this.line(graphics, 3.0f, 469.0, 155.0, 470.0, 147.0);
        this.line(graphics, 3.0f, 489.0, 157.0, 492.0, 149.0);
        double d4 = 300.0 + d3 * Math.sin(d * d2);
        double d5 = -150.0 + d3 * Math.cos(d * d2);
        this.x1 = (int)(298.0 + 0.5 * d4 + 0.5);
        this.y1 = (int)(217.0 - 0.1 * d4 - 0.5 * d5 + 0.5);
        this.line(graphics, 3.0f, 448.0, 262.0, this.x1, this.y1);
        graphics.setColor(this.COL_U);
        graphics.fillPolygon(this.pVM1);
        graphics.setColor(this.BLACK);
        graphics.drawPolygon(this.pVM1);
        graphics.drawLine(398, 297, 398, 247);
        graphics.drawLine(398, 147, 358, 137);
        graphics.drawLine(498, 227, 498, 127);
        graphics.fillOval(421, 270, 4, 4);
        graphics.fillOval(471, 260, 4, 4);
        this.line(graphics, 3.0f, 468.0, 246.0, 478.0, 244.0);
        this.line(graphics, 3.0f, 473.0, 240.0, 473.0, 250.0);
        this.line(graphics, 3.0f, 418.0, 256.0, 428.0, 254.0);
        this.line(graphics, 3.0f, 448.0, 270.0, 444.0, 255.0);
        this.line(graphics, 3.0f, 448.0, 270.0, 452.0, 254.0);
        if (!this.iArrows) {
            return;
        }
        graphics.setColor(this.COL_I);
        if (d > 0.0) {
            this.x0 = 331;
            this.y0 = 294;
            this.arrowTo(graphics, 326, 295);
            this.x0 = 295;
            this.y0 = 136;
            this.arrowTo(graphics, 300, 135);
        }
        if (d < 0.0) {
            this.x0 = 326;
            this.y0 = 295;
            this.arrowTo(graphics, 331, 294);
            this.x0 = 300;
            this.y0 = 135;
            this.arrowTo(graphics, 295, 136);
        }
    }

    void wires1(Graphics graphics) {
        graphics.setColor(this.current ? this.COL_I : this.BLACK);
        this.x0 = 250;
        this.y0 = 175;
        this.lineTo(graphics, 250, 145);
        this.lineTo(graphics, 350, 125);
        this.lineTo(graphics, 350, 265);
        this.lineTo(graphics, 460, 243);
        this.lineTo(graphics, 516, 257);
    }

    void wiresDC2(Graphics graphics) {
        graphics.setColor(this.current ? this.COL_I : this.BLACK);
        this.x0 = 516;
        this.y0 = 257;
        this.lineTo(graphics, 481, 264);
        this.lineTo(graphics, 473, 262);
        this.x0 = 250;
        this.y0 = 236;
        this.lineTo(graphics, 250, 285);
        this.lineTo(graphics, 306, 299);
        this.lineTo(graphics, 431, 274);
        this.lineTo(graphics, 423, 272);
        this.line(graphics, 3.0f, 250.0, 285.0, 287.0, 278.0);
        this.line(graphics, 3.0f, 333.0, 268.0, 350.0, 265.0);
        graphics.fillOval(246, 281, 9, 9);
        graphics.fillOval(346, 261, 9, 9);
    }

    void wiresAC2(Graphics graphics) {
        graphics.setColor(this.COL_I);
        this.x0 = 516;
        this.y0 = 257;
        this.lineTo(graphics, 481, 264);
        this.lineTo(graphics, 473, 262);
        this.x0 = 274;
        this.y0 = 242;
        this.lineTo(graphics, 274, 291);
        this.lineTo(graphics, 306, 299);
        this.lineTo(graphics, 431, 274);
        this.lineTo(graphics, 423, 272);
        this.x0 = 274;
        this.y0 = 291;
        this.lineTo(graphics, 250, 285);
        this.lineTo(graphics, 287, 278);
        this.line(graphics, 3.0f, 333.0, 268.0, 350.0, 265.0);
        graphics.fillOval(270, 287, 9, 9);
        graphics.fillOval(346, 261, 9, 9);
        graphics.setColor(this.BG);
        graphics.drawLine(272, 265, 272, 285);
        graphics.drawLine(276, 265, 276, 285);
    }

    void resistor(Graphics graphics) {
        graphics.setColor(Color.green);
        graphics.fillPolygon(this.pW);
        graphics.fillOval(280, 267, 16, 20);
        graphics.fillOval(317, 260, 16, 20);
        graphics.setColor(this.BLACK);
        graphics.drawOval(280, 267, 16, 20);
        graphics.drawArc(317, 260, 16, 20, 270, 180);
        graphics.drawLine(288, 267, 325, 260);
        graphics.drawLine(288, 287, 325, 280);
        graphics.drawString("R", 300, 260);
    }

    void diagram(Graphics graphics, int n, int n2) {
        double d;
        int n3;
        int n4;
        int n5;
        graphics.setColor(this.BLACK);
        graphics.drawLine(n - 10, n2, n + 215, n2);
        graphics.drawLine(n + 205, n2 - 3, n + 215, n2);
        graphics.drawLine(n + 205, n2 + 3, n + 215, n2);
        for (n5 = 1; n5 <= 5; ++n5) {
            graphics.drawLine(n + n5 * 40, n2 - 3, n + n5 * 40, n2 + 3);
        }
        graphics.drawLine(n, n2 + 45, n, n2 - 45);
        graphics.drawLine(n - 3, n2 - 35, n, n2 - 45);
        graphics.drawLine(n + 3, n2 - 35, n, n2 - 45);
        for (n5 = -2; n5 <= 2; ++n5) {
            graphics.drawLine(n - 3, n2 + n5 * 15, n + 3, n2 + n5 * 15);
        }
        graphics.drawString("t", n + 210, n2 + 15);
        graphics.drawString("U", n - 15, n2 - 35);
        double d2 = this.T > 0.0 ? 150.0 / this.T : 0.0;
        int n6 = n4 = n;
        int n7 = n3 = (int)Math.round((double)n2 - (double)this.direction * d2);
        while (n4 < n + 200) {
            n6 = n4;
            n7 = n3;
            n4 = n6 + 1;
            double d3 = (double)(n4 - n) * 1.5707963267948966 / this.T;
            d = d2 * Math.cos(d3);
            if (this.genDC) {
                d = Math.abs(d);
            }
            if ((n3 = (int)Math.round((double)n2 - (double)this.direction * d)) < n2 + 4 && n3 > n2 - 4 && this.T < 10.0 && this.genDC) {
                n3 = n2;
            }
            graphics.drawLine(n6, n7, n4, n3);
        }
        n6 = (int)Math.round((double)n + this.t * 4.0);
        d = d2 * this.cos;
        if (this.genDC) {
            d = Math.abs(d);
        }
        n7 = (int)Math.round((double)n2 - (double)this.direction * d);
        graphics.setColor(this.COL_U);
        graphics.fillOval(n6 - 2, n7 - 2, 5, 5);
    }

    void movementArrow(Graphics graphics, int n) {
        if (!this.vArrows || this.T <= 0.0) {
            return;
        }
        int n2 = 40;
        int n3 = 240 - n * 160;
        int n4 = (3 - 2 * n) * this.direction;
        graphics.setColor(this.BLACK);
        this.moveTo(0.0, 200.0, n3);
        this.arrowTo(graphics, -n4 * 50, 200.0, n3);
    }

    void fieldLines(Graphics graphics, int n) {
        if (!this.bArrows) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: {
                n2 = 2;
                n3 = 3;
                break;
            }
            case 1: {
                n2 = 0;
                n3 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                n3 = 5;
            }
        }
        graphics.setColor(this.COL_B);
        for (n = n2; n < n3; ++n) {
            this.x0 = 130 + n * 20;
            this.y0 = 112 + n * 5;
            this.arrowTo(graphics, this.x0, this.y0 + 18);
            this.arrowTo(graphics, this.x0, this.y0 + 105);
            this.lineTo(graphics, this.x0, this.y0 + 15);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.vArrows = this.cb1.isSelected();
        this.bArrows = this.cb2.isSelected();
        this.iArrows = this.cb3.isSelected();
        Object object = itemEvent.getSource();
        if (object != this.rbOK && object != this.rbMK) {
            return;
        }
        this.genDC = this.rbMK.isSelected();
        this.on = true;
        this.t = 0.0;
        this.phi = 0.0;
        this.cos = 1.0;
        this.sin = 0.0;
        this.p.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bR) {
            if (this.T > 0.0) {
                this.on = true;
            }
            this.direction = -this.direction;
            this.t = 0.0;
            this.phi = 0.0;
            this.cos = 1.0;
            this.sin = 0.0;
        } else if (object == this.bOn) {
            this.on = !this.on;
        }
        this.p.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = this.scr.getValue();
        if (n > 10) {
            n = 10;
            this.scr.setValue(10);
        }
        if (n > 0) {
            this.on = true;
            this.T = 50.0 / (double)n;
            this.nMax = n;
            this.t = 0.0;
            this.phi = 0.0;
            this.cos = 1.0;
            this.sin = 0.0;
        } else {
            this.on = true;
            this.T = -1.0;
            this.nMax = 0;
            this.t = 0.0;
            this.phi = 0.0;
            this.cos = 1.0;
            this.sin = 0.0;
        }
    }

    class Canvas1
    extends JPanel {
        Canvas1() {
        }

        public void paint(Graphics graphics) {
            graphics.setFont(Generator.this.fH);
            double d = Generator.this.genDC ? 0.3 : 0.0;
            Generator.this.current = true;
            if (Generator.this.phi > 1.5707963267948966 - d && Generator.this.phi < 1.5707963267948966 + d) {
                boolean bl = Generator.this.current = !Generator.this.genDC;
            }
            if (Generator.this.phi > 4.71238898038469 - d && Generator.this.phi < 4.71238898038469 + d) {
                Generator.this.current = !Generator.this.genDC;
            }
            graphics.setColor(Generator.this.BG);
            graphics.fillRect(0, 0, Generator.this.width0, Generator.this.height);
            Generator.this.magnet(graphics);
            int n = (int)(Generator.this.phi / 1.5707963267948966);
            if (Generator.this.direction == -1) {
                n = n % 2 == 0 ? n + 1 : n - 1;
            }
            switch (n) {
                case 0: {
                    Generator.this.movementArrow(graphics, 2);
                    Generator.this.armature(graphics, 2);
                    Generator.this.fieldLines(graphics, 1);
                    Generator.this.fieldLines(graphics, 0);
                    Generator.this.fieldLines(graphics, 2);
                    Generator.this.armature(graphics, 1);
                    Generator.this.movementArrow(graphics, 1);
                    break;
                }
                case 1: {
                    Generator.this.armature(graphics, 2);
                    Generator.this.fieldLines(graphics, 1);
                    Generator.this.fieldLines(graphics, 0);
                    Generator.this.movementArrow(graphics, 2);
                    Generator.this.movementArrow(graphics, 1);
                    Generator.this.fieldLines(graphics, 2);
                    Generator.this.armature(graphics, 1);
                    break;
                }
                case 2: {
                    Generator.this.movementArrow(graphics, 1);
                    Generator.this.armature(graphics, 1);
                    Generator.this.fieldLines(graphics, 1);
                    Generator.this.fieldLines(graphics, 0);
                    Generator.this.fieldLines(graphics, 2);
                    Generator.this.armature(graphics, 2);
                    Generator.this.movementArrow(graphics, 2);
                    break;
                }
                case 3: {
                    Generator.this.armature(graphics, 1);
                    Generator.this.fieldLines(graphics, 1);
                    Generator.this.fieldLines(graphics, 0);
                    Generator.this.movementArrow(graphics, 1);
                    Generator.this.movementArrow(graphics, 2);
                    Generator.this.fieldLines(graphics, 2);
                    Generator.this.armature(graphics, 2);
                }
            }
            if (Generator.this.genDC) {
                Generator.this.contact2(graphics);
                Generator.this.commutator(graphics);
                Generator.this.contact1(graphics);
                Generator.this.resistor(graphics);
                Generator.this.wires1(graphics);
                Generator.this.crank(graphics, -100);
                Generator.this.voltmeter(graphics, Generator.this.T > 0.0 ? (double)(Generator.this.direction * 5) / Generator.this.T * Math.abs(Generator.this.cos) : 0.0);
                Generator.this.wiresDC2(graphics);
            } else {
                Generator.this.contact3(graphics);
                Generator.this.leftRing(graphics);
                Generator.this.rightRing(graphics);
                Generator.this.contact1(graphics);
                Generator.this.resistor(graphics);
                Generator.this.wires1(graphics);
                Generator.this.crank(graphics, -160);
                Generator.this.voltmeter(graphics, Generator.this.T > 0.0 ? (double)(Generator.this.direction * 5) / Generator.this.T * Generator.this.cos : 0.0);
                Generator.this.wiresAC2(graphics);
            }
            Generator.this.diagram(graphics, 300, 65);
            String string = Generator.this.T < 0.0 ? "0" : Generator.this.appl.toString(60.0 / Generator.this.T, 1);
            Generator.this.lDrZ.setText(string + Generator.this.text(5));
        }
    }
}

