/*
 * Decompiled with CFR 0.152.
 */
package optics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import optics.OpticElement;

public final class Aperature
extends OpticElement {
    int openingSize;

    public Aperature(int n, int n2, int n3, boolean bl, boolean bl2, double d, boolean bl3) {
        this.propertyDrag = bl3;
        this.info = bl;
        this.drag = bl2;
        this.xPosition = n;
        this.yPosition = n2;
        this.openingSize = n3;
    }

    public double[] transform(double[] dArray, Rectangle rectangle, int n) {
        double d = dArray[0] - (double)(rectangle.height / 2);
        dArray[0] = dArray[0] * this.mat[0][0] + dArray[1] * this.mat[0][1];
        dArray[1] = d * this.mat[1][0] + dArray[1] * this.mat[1][1];
        return dArray;
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.yellow);
        graphics.drawLine(this.xPosition, 0, this.xPosition, rectangle.height / 2 - this.openingSize / 2);
        graphics.drawLine(this.xPosition, rectangle.height, this.xPosition, rectangle.height / 2 + this.openingSize / 2);
    }

    public void paintActive(Graphics graphics, Rectangle rectangle) {
        if (this.drag) {
            graphics.setColor(Color.white);
            graphics.fillOval(this.xPosition - 3, rectangle.height / 2 - this.openingSize / 2 - 3, 6, 6);
            graphics.fillOval(this.xPosition - 3, rectangle.height / 2 + this.openingSize / 2 - 3, 6, 6);
        }
        if (this.info) {
            graphics.setColor(Color.white);
            graphics.drawString(String.valueOf("x = ").concat(String.valueOf(this.df.format(1.0 * (double)this.xPosition / (double)this.pixPerUnit))), this.xPosition, rectangle.height - 50);
            graphics.drawString(String.valueOf("opening = ").concat(String.valueOf(this.df.format(1.0 * (double)this.openingSize / (double)this.pixPerUnit))), this.xPosition, rectangle.height - 30);
        }
    }

    public void setOpeningSize(int n) {
        this.openingSize = n <= 0 ? 0 : n;
    }

    public int getOpeningSize() {
        return this.openingSize;
    }

    public int isInside(int n, int n2, Rectangle rectangle) {
        if (n > this.xPosition - 10 && n < this.xPosition + 10 && (n2 < rectangle.height / 2 - this.openingSize / 2 - 5 || n2 > rectangle.height / 2 + this.openingSize / 2 + 5)) {
            return 1;
        }
        if (this.drag && n > this.xPosition - 10 && n < this.xPosition + 10 && n2 > rectangle.height / 2 - this.openingSize / 2 - 5 && n2 < rectangle.height / 2 - this.openingSize / 2 + 5) {
            return 2;
        }
        if (this.drag && n > this.xPosition - 10 && n < this.xPosition + 10 && n2 > rectangle.height / 2 + this.openingSize / 2 - 5 && n2 < rectangle.height / 2 + this.openingSize / 2 + 5) {
            return 3;
        }
        return 0;
    }

    public String getType() {
        return "aperature";
    }
}

