/*
 * Decompiled with CFR 0.152.
 */
package optics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Vector;
import optics.Aperature;
import optics.Dielectric;
import optics.ISource;
import optics.IndexChange;
import optics.Lens;
import optics.Mirror;
import optics.Mirror2;
import optics.OpticElement;
import optics.PSource;
import optics.Refraction;
import optics.Screen;
import optics.Source;

public final class Bench
extends Panel {
    PSource tempPSource = new PSource(0, 0, 0.0, 0, true, false, 1.0, false);
    Vector v = new Vector();
    Vector sv = new Vector();
    int i = 0;
    int si = 0;
    int inc;
    int pixPerUnit = 100;
    int maxNumber = 100;
    int maxSNumber = 100;
    int widthOfLens;
    int spacingInt;
    int temp1;
    int temp2;
    Color rayColor = null;
    Color elementColor = null;
    DecimalFormat df = new DecimalFormat("0.##");
    int[] x = new int[this.maxNumber];
    int[] y = new int[this.maxNumber];
    int[] sx = new int[this.maxNumber];
    int[] sy = new int[this.maxNumber];
    int xOld;
    int xNew;
    int yOld;
    int yNew;
    int indexOfPSources;
    double mOld;
    double slope;
    double yNewDouble;
    double[] f = new double[this.maxNumber];
    double[] ray = new double[2];
    OpticElement activeElement = null;
    int isInsideOpticElement;
    boolean isControlDown;
    boolean blocked = false;
    Image osi = null;
    int iheight;
    int iwidth;
    int step;
    private int xDown = 0;
    private int yDown = 0;
    private int xLast = 0;
    private int yLast = 0;

    public Bench() {
        this.setBackground(Color.black);
        this.addScreen(1500, 0, false, false, 1.0, false);
        this.addScreen(-10, 0, false, false, 1.0, false);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setPixPerUnit(int n) {
        OpticElement opticElement;
        this.pixPerUnit = n;
        this.i = 0;
        while (this.i < this.v.size()) {
            opticElement = (OpticElement)this.v.elementAt(this.i);
            opticElement.setPixPerUnit(this.pixPerUnit);
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.sv.size()) {
            opticElement = (OpticElement)this.sv.elementAt(this.i);
            opticElement.setPixPerUnit(this.pixPerUnit);
            ++this.i;
        }
    }

    void setRayColor(Color color) {
        this.rayColor = color;
    }

    void setElementColor(Color color) {
        this.elementColor = color;
    }

    private void adjustHeight() {
        OpticElement opticElement;
        int n = (this.getBounds().height - this.iheight) / 2;
        this.i = 0;
        while (this.i < this.v.size()) {
            opticElement = (OpticElement)this.v.elementAt(this.i);
            opticElement.yPosition += n;
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.sv.size()) {
            opticElement = (OpticElement)this.sv.elementAt(this.i);
            opticElement.yPosition += n;
            ++this.i;
        }
    }

    public void paint(Graphics graphics) {
        OpticElement opticElement;
        this.sort(this.v);
        Rectangle rectangle = this.getBounds();
        if (this.osi == null || rectangle.width != this.iwidth || rectangle.height != this.iheight) {
            this.adjustHeight();
            this.iheight = rectangle.height;
            this.iwidth = rectangle.width;
            this.osi = this.createImage(this.iwidth, this.iheight);
        }
        Graphics graphics2 = this.osi.getGraphics();
        graphics2.setColor(Color.black);
        graphics2.fillRect(0, 0, this.iwidth, this.iheight);
        this.i = 0;
        while (this.i < this.v.size()) {
            opticElement = (OpticElement)this.v.elementAt(this.i);
            this.x[this.i] = opticElement.getX();
            this.y[this.i] = opticElement.getY();
            if (opticElement.getType() == "lens") {
                this.f[this.i] = opticElement.getFocalLength();
            }
            opticElement.paint(graphics2, rectangle);
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.sv.size()) {
            opticElement = (OpticElement)this.sv.elementAt(this.i);
            this.sx[this.i] = opticElement.getX();
            this.sy[this.i] = opticElement.getY();
            opticElement.paint(graphics2, rectangle);
            ++this.i;
        }
        if (this.activeElement != null) {
            this.activeElement.paintActive(graphics2, rectangle);
        }
        graphics2.setColor(Color.yellow);
        graphics2.drawLine(0, rectangle.height / 2, rectangle.width, rectangle.height / 2);
        this.si = 0;
        while (this.si < this.sv.size()) {
            opticElement = (OpticElement)this.sv.elementAt(this.si);
            if (opticElement.getRayIncrement() != (double)3 && opticElement.getType() == "source") {
                double d;
                this.slope = d = opticElement.getRaySlope();
                while (this.slope <= -d) {
                    this.xOld = opticElement.getX();
                    this.yOld = opticElement.getY();
                    this.ray[0] = this.yOld;
                    this.ray[1] = this.slope;
                    graphics2.setColor(opticElement.getRayColor());
                    this.drawRay(graphics2, rectangle, opticElement.getDirection());
                    this.slope += opticElement.getRayIncrement();
                }
            }
            if (opticElement.getRayIncrement() == (double)3 && opticElement.getType() == "source") {
                this.xOld = opticElement.getX();
                this.yOld = opticElement.getY();
                this.ray[0] = this.yOld;
                this.ray[1] = 0.0;
                graphics2.setColor(opticElement.getRayColor());
                this.drawRay(graphics2, rectangle, opticElement.getDirection());
            }
            if (opticElement.getType() == "isource") {
                int n = opticElement.getSpread();
                int n2 = opticElement.getSpacing();
                double d = opticElement.getAngle();
                this.spacingInt = 0;
                while (this.spacingInt <= n / 2) {
                    this.xOld = opticElement.getX();
                    this.yOld = opticElement.getY() - this.spacingInt;
                    this.ray[0] = this.yOld;
                    this.ray[1] = d;
                    graphics2.setColor(opticElement.getRayColor());
                    this.drawRay(graphics2, rectangle, opticElement.getDirection());
                    this.xOld = opticElement.getX();
                    this.yOld = opticElement.getY() + this.spacingInt;
                    this.ray[0] = this.yOld;
                    this.ray[1] = d;
                    this.drawRay(graphics2, rectangle, opticElement.getDirection());
                    this.spacingInt += n2;
                }
            }
            if (opticElement.getType() == "psource") {
                opticElement.setNextElement(this.findStart(opticElement.getX(), 1));
                for (int i = 0; opticElement != null && i < 10; ++i) {
                    opticElement = this.drawPSourceRay((Source)opticElement, graphics2, rectangle);
                }
                this.indexOfPSources = 0;
            }
            ++this.si;
        }
        if (this.activeElement != null) {
            this.drawCoords(graphics2, this.activeElement.getX(), this.activeElement.getY());
        }
        graphics2.dispose();
        graphics.drawImage(this.osi, 0, 0, this);
    }

    public OpticElement drawPSourceRay(OpticElement opticElement, Graphics graphics, Rectangle rectangle) {
        int n;
        int n2;
        graphics.setColor(Color.red);
        int n3 = opticElement.getX();
        int n4 = opticElement.getY();
        OpticElement opticElement2 = null;
        OpticElement opticElement3 = null;
        boolean bl = false;
        int n5 = n2 = opticElement.getDirection();
        for (n = opticElement.getNextElement(); n < this.v.size() - 1 && n >= 0 && !bl; n += n5) {
            opticElement2 = (OpticElement)this.v.elementAt(n);
            if (opticElement2.getType() != "lens" && opticElement2.getType() != "mirror" && opticElement2.getType() != "dielectric") continue;
            opticElement3 = opticElement2;
            bl = true;
            if (!(opticElement3 instanceof Mirror)) continue;
            n5 = -n2;
        }
        if (!bl) {
            return null;
        }
        if ((double)n3 != (double)opticElement3.getX() - opticElement3.getFocalLength()) {
            int n6 = opticElement3.getX();
            int n7 = opticElement3.getY();
            double d = opticElement3.getFocalLength();
            int n8 = 0;
            int n9 = 0;
            if (opticElement3 instanceof Mirror) {
                if (d == 0.0) {
                    n9 = n4;
                    n8 = 2 * n6 - n3;
                } else {
                    int n10 = d - (double)(n6 - n3) == 0.0 ? 10000 : (int)((double)n6 - d * (double)(n6 - n3) / (d - (double)(n6 - n3)));
                    n8 = 2 * n6 - n10;
                    n9 = (int)((double)rectangle.height / 2.0 + (double)(n10 - n6) * ((double)rectangle.height / 2.0 - (double)n4) / (double)(n6 - n3));
                }
            } else {
                n8 = d - (double)(n6 - n3) == 0.0 ? 10000 : n6 - (int)((double)n2 * (d * (double)(n6 - n3)) / (d - (double)(n6 - n3)));
                n9 = (int)((double)rectangle.height / 2.0 + (double)n2 * ((double)(n8 - n6) * ((double)rectangle.height / 2.0 - (double)n4)) / (double)(n6 - n3));
            }
            if (opticElement.drawPRay) {
                // empty if block
            }
            if (opticElement.drawDashedRay) {
                this.drawDashedLine(n3, n4, n6, n4, graphics);
                this.drawDashedLine(n3, n4, n6, rectangle.height / 2, graphics);
                this.drawDashedLine(n3, n4, n6, n9, graphics);
                this.drawDashedLine(n6, n4, n8, n9, graphics);
                this.drawDashedLine(n6, rectangle.height / 2, n8, n9, graphics);
                this.drawDashedLine(n6, n9, n8, n9, graphics);
            }
            if (opticElement.drawSourceRay) {
                graphics.setColor(opticElement.getRayColor());
                this.xOld = n3;
                this.yOld = n4;
                this.ray[0] = n4;
                this.ray[1] = (double)(n6 - n3) - d == 0.0 ? 0.0 : (double)(-(n4 - rectangle.height / 2)) / ((double)(n6 - n3) - d);
                this.drawRay(graphics, rectangle, 1);
                this.xOld = n3;
                this.yOld = n4;
                this.ray[0] = n4;
                this.ray[1] = 0.0;
                this.drawRay(graphics, rectangle, 1);
                this.xOld = n3;
                this.yOld = n4;
                this.ray[0] = n4;
                if (n3 - n6 != 0 || !(opticElement3 instanceof Mirror) && n8 - n6 != 0) {
                    this.ray[1] = opticElement3 instanceof Mirror ? ((double)n4 - (double)rectangle.height / 2.0) / (double)(n3 - n6) : ((double)n9 - (double)rectangle.height / 2.0) / (double)(n8 - n6);
                    this.drawRay(graphics, rectangle, 1);
                }
            }
            ++this.indexOfPSources;
            this.tempPSource.init(n8, n9, 0.0, 0, true, false, 1.0, false);
            graphics.setColor(Color.white);
            if (n9 - rectangle.height / 2 < 0) {
                graphics.drawString(String.valueOf("").concat(String.valueOf(this.indexOfPSources)), n8, n9 - 20);
            } else {
                graphics.drawString(String.valueOf("").concat(String.valueOf(this.indexOfPSources)), n8, n9 + 20);
            }
            this.tempPSource.setNextElement(n);
            this.tempPSource.paintTemp(graphics, rectangle);
            this.tempPSource.setPixPerUnit(this.pixPerUnit);
            this.tempPSource.info = opticElement.info;
            this.tempPSource.drawDashedRay = false;
            this.tempPSource.drawSourceRay = false;
            this.tempPSource.drawPRay = false;
            this.tempPSource.setDirection(n5);
            if (this.activeElement instanceof PSource) {
                this.tempPSource.paintTempActive(graphics, rectangle);
            }
        }
        bl = false;
        return this.tempPSource;
    }

    public void drawDashedLine(int n, int n2, int n3, int n4, Graphics graphics) {
        graphics.setColor(new Color(191, 191, 255));
        double d = (double)(n2 - n4) * 1.0 / (double)(n - n3);
        double d2 = n;
        double d3 = n2;
        for (int i = 0; i < Math.abs(n3 - n); i += 3) {
            graphics.fillOval((int)d2, (int)d3, 1, 1);
            if (d2 < (double)n3) {
                d2 += 3.0;
                d3 += 3.0 * d;
                continue;
            }
            d2 -= 3.0;
            d3 -= 3.0 * d;
        }
    }

    private int findStart(int n, int n2) {
        for (int i = 0; i < this.v.size(); ++i) {
            OpticElement opticElement = (OpticElement)this.v.elementAt(i);
            if (n2 == 1 && opticElement.getX() > n) {
                return i;
            }
            if (n2 != -1 || opticElement.getX() <= n) continue;
            return i - 1;
        }
        if (n2 == 1) {
            return this.v.size() - 1;
        }
        return this.v.size() - 1;
    }

    public void drawRay(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = 0;
        this.step = n;
        for (int i = this.findStart(this.xOld, this.step); i >= 0 && i < this.v.size(); i += this.step) {
            if (n2 > 30) {
                return;
            }
            ++n2;
            OpticElement opticElement = (OpticElement)this.v.elementAt(i);
            this.xNew = opticElement.getX();
            this.yNewDouble = this.ray[0] + this.ray[1] * (double)(this.xNew - this.xOld);
            this.yNew = (int)this.yNewDouble;
            if (opticElement instanceof Aperature && (opticElement.getOpeningSize() == 0 || this.yNew < rectangle.height / 2 - opticElement.getOpeningSize() / 2 || this.yNew > rectangle.height / 2 + opticElement.getOpeningSize() / 2)) {
                this.blocked = true;
            }
            if ((opticElement instanceof Lens || opticElement instanceof Mirror) && ((double)this.yNew < (double)(rectangle.height / 2) - (double)rectangle.height * opticElement.size / (double)2 || (double)this.yNew > (double)(rectangle.height / 2) + (double)rectangle.height * opticElement.size / (double)2)) {
                this.blocked = true;
            }
            if (this.yNew < 0 || this.yNew > rectangle.height || this.xNew < 0 || this.xNew > rectangle.width) {
                this.blocked = true;
            }
            if (!this.blocked) {
                graphics.drawLine(this.xOld, this.yOld, this.xNew, this.yNew);
            }
            if (this.blocked) {
                graphics.drawLine(this.xOld, this.yOld, this.xNew, this.yNew);
                break;
            }
            this.yOld = this.yNew;
            this.ray[0] = this.yNewDouble;
            this.xOld = this.xNew;
            Rectangle rectangle2 = this.getBounds();
            this.ray = opticElement.transform(this.ray, rectangle2, this.step);
            if (opticElement.errCode == 2) {
                this.step = -this.step;
            }
            if (opticElement.errCode == 1) {
                this.blocked = true;
                break;
            }
            if (opticElement instanceof Screen) {
                graphics.fillOval(this.xNew - 2, this.yNew - 2, 4, 4);
            }
            if (!(opticElement instanceof Mirror)) continue;
            this.step = -this.step;
        }
        this.blocked = false;
    }

    public void sort(Vector vector) {
        boolean bl = false;
        this.inc = 0;
        while (this.inc <= this.maxNumber) {
            this.i = 0;
            while (this.i < vector.size() - 1) {
                OpticElement opticElement = (OpticElement)vector.elementAt(this.i);
                OpticElement opticElement2 = (OpticElement)vector.elementAt(this.i + 1);
                if (opticElement.getX() > opticElement2.getX()) {
                    bl = true;
                    vector.removeElementAt(this.i);
                    vector.insertElementAt(opticElement, this.i + 1);
                }
                ++this.i;
            }
            ++this.inc;
        }
        if (bl) {
            this.recalculateIndexOfRefraction();
        }
    }

    void recalculateIndexOfRefraction() {
        double d = 1.0;
        this.i = 0;
        while (this.i < this.v.size() - 1) {
            OpticElement opticElement = (OpticElement)this.v.elementAt(this.i);
            opticElement.indexOfRefraction = d;
            if (opticElement instanceof Dielectric) {
                if ((d += ((Dielectric)opticElement).delN) < 1.0) {
                    d = 1.0;
                }
                opticElement.focalLength = (double)((Dielectric)opticElement).R / ((Dielectric)opticElement).delN;
            }
            ++this.i;
        }
    }

    public void propagate(double[] dArray, int n) {
        dArray[0] = dArray[0] * 1.0 + dArray[1] * (double)n;
        dArray[1] = dArray[0] * 0.0 + dArray[1] * 1.0;
    }

    public void addLens(int n, int n2, double d, boolean bl, boolean bl2, double d2, boolean bl3) {
        if (this.v.size() >= this.maxNumber) {
            return;
        }
        Lens lens = new Lens(n, n2, d, bl, bl2, d2, bl3);
        lens.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            lens.setElementColor(this.elementColor);
        }
        this.v.addElement(lens);
    }

    public void addIndexChange(int n, int n2, double d, boolean bl, boolean bl2, double d2, boolean bl3) {
        if (this.v.size() >= this.maxNumber) {
            return;
        }
        IndexChange indexChange = new IndexChange(n, n2, d, bl, bl2, d2, bl3);
        indexChange.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            indexChange.setElementColor(this.elementColor);
        }
        this.v.addElement(indexChange);
        this.sort(this.v);
        this.recalculateIndexOfRefraction();
    }

    public void addMirror(int n, int n2, double d, boolean bl, boolean bl2, double d2, boolean bl3) {
        if (this.v.size() >= this.maxNumber) {
            return;
        }
        Mirror mirror = new Mirror(n, n2, d, bl, bl2, d2, bl3);
        mirror.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            mirror.setElementColor(this.elementColor);
        }
        this.v.addElement(mirror);
    }

    public void addSphericalMirror(int n, int n2, double d, boolean bl, boolean bl2, double d2, boolean bl3) {
        if (this.v.size() >= this.maxNumber) {
            return;
        }
        Mirror2 mirror2 = new Mirror2(n, n2, d, bl, bl2, d2, bl3);
        mirror2.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            mirror2.setElementColor(this.elementColor);
        }
        this.v.addElement(mirror2);
    }

    public void addDielectric(int n, int n2, double d, int n3, boolean bl, boolean bl2, double d2, boolean bl3) {
        if (this.v.size() >= this.maxNumber) {
            return;
        }
        Dielectric dielectric = new Dielectric(n, n2, d, n3, bl, bl2, d2, bl3);
        dielectric.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            dielectric.setElementColor(this.elementColor);
        }
        this.v.addElement(dielectric);
        this.sort(this.v);
        this.recalculateIndexOfRefraction();
    }

    public void addSource(int n, int n2, double d, double d2, boolean bl, boolean bl2, int n3, boolean bl3) {
        if (this.sv.size() >= this.maxSNumber) {
            return;
        }
        Source source = new Source(n, n2, d, d2, bl, bl2, n3, bl3);
        source.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            source.setElementColor(this.elementColor);
        }
        if (this.rayColor != null) {
            source.setRayColor(this.rayColor);
        }
        this.sv.addElement(source);
    }

    public void addAperature(int n, int n2, int n3, boolean bl, boolean bl2, double d, boolean bl3) {
        if (this.sv.size() >= this.maxSNumber) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        Aperature aperature = new Aperature(n, n2, n3, bl, bl2, d, bl3);
        aperature.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            aperature.setElementColor(this.elementColor);
        }
        this.v.addElement(aperature);
    }

    public void addPSource(int n, int n2, boolean bl, boolean bl2, double d, boolean bl3) {
        if (this.sv.size() >= this.maxSNumber) {
            return;
        }
        PSource pSource = new PSource(n, n2, 0.0, 0, bl, bl2, d, bl3);
        pSource.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            pSource.setElementColor(this.elementColor);
        }
        if (this.rayColor != null) {
            pSource.setRayColor(this.rayColor);
        }
        this.sv.addElement(pSource);
    }

    public void addRefraction(int n, int n2, double d, int n3, boolean bl, boolean bl2, double d2, boolean bl3) {
        Refraction refraction = new Refraction(n, n2, d, n3, bl, bl2, d2, bl3);
        refraction.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            refraction.setElementColor(this.elementColor);
        }
        this.v.addElement(refraction);
        this.sort(this.v);
        this.recalculateIndexOfRefraction();
    }

    public void addISource(int n, int n2, int n3, double d, boolean bl, boolean bl2, int n4, boolean bl3) {
        if (this.sv.size() >= this.maxSNumber) {
            return;
        }
        ISource iSource = new ISource(n, n2, n3, d, bl, bl2, n4, bl3);
        iSource.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            iSource.setElementColor(this.elementColor);
        }
        if (this.rayColor != null) {
            iSource.setRayColor(this.rayColor);
        }
        this.sv.addElement(iSource);
    }

    public void addScreen(int n, int n2, boolean bl, boolean bl2, double d, boolean bl3) {
        if (this.v.size() >= this.maxNumber) {
            return;
        }
        Screen screen = new Screen(n, n2, bl, bl2, d, bl3);
        screen.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            screen.setElementColor(this.elementColor);
        }
        this.v.addElement(screen);
    }

    public void clearOptics() {
        this.activeElement = null;
        this.v.removeAllElements();
        this.sv.removeAllElements();
        this.addScreen(1500, 0, false, false, 1.0, false);
        this.addScreen(-10, 0, false, false, 1.0, false);
        this.sort(this.v);
        this.recalculateIndexOfRefraction();
        this.repaint();
    }

    public void clearActiveElement() {
        if (this.activeElement != null) {
            if (this.v.indexOf(this.activeElement) != -1) {
                this.v.removeElementAt(this.v.indexOf(this.activeElement));
            }
            if (this.sv.indexOf(this.activeElement) != -1) {
                this.sv.removeElementAt(this.sv.indexOf(this.activeElement));
            }
        }
        this.activeElement = null;
        this.sort(this.v);
        this.recalculateIndexOfRefraction();
        this.repaint();
    }

    public void mousePressed(int n, int n2) {
        OpticElement opticElement;
        this.xDown = n;
        this.yDown = n2;
        this.xLast = n;
        this.yLast = n2;
        Rectangle rectangle = this.getBounds();
        this.i = 0;
        while (this.i < this.v.size()) {
            opticElement = (OpticElement)this.v.elementAt(this.i);
            if ((opticElement.drag || opticElement.propertyDrag) && (opticElement.isInside(n, n2, rectangle) == 1 || opticElement.isInside(n, n2, rectangle) == 2 || opticElement.isInside(n, n2, rectangle) == 3)) {
                this.activeElement = opticElement;
                break;
            }
            this.activeElement = null;
            ++this.i;
        }
        if (this.activeElement == null) {
            this.i = 0;
            while (this.i < this.sv.size()) {
                opticElement = (OpticElement)this.sv.elementAt(this.i);
                if ((opticElement.drag || opticElement.propertyDrag) && (opticElement.isInside(n, n2, rectangle) == 1 || opticElement.isInside(n, n2, rectangle) == 2)) {
                    this.activeElement = opticElement;
                    break;
                }
                this.activeElement = null;
                ++this.i;
            }
        }
    }

    public void mouseReleased(int n, int n2) {
        this.isControlDown = false;
        this.repaint();
    }

    public void mouseDragged(int n, int n2) {
        Rectangle rectangle = this.getBounds();
        if (this.activeElement != null) {
            if (this.activeElement.getDrag()) {
                if (this.isInsideOpticElement == 1 && !this.isControlDown && this.activeElement.getType() != "source" || this.activeElement.getType() == "psource") {
                    this.activeElement.setX(n, rectangle);
                    this.activeElement.setY(n2, rectangle);
                    this.repaint();
                }
                if (!(this.isInsideOpticElement != 1 || this.isControlDown || this.activeElement.getType() != "source" && this.activeElement.getType() != "isource")) {
                    this.activeElement.setX(n, rectangle);
                    this.activeElement.setY(n2, rectangle);
                    this.repaint();
                }
                if (this.activeElement.getType() == "aperature" && this.isInsideOpticElement == 2) {
                    this.activeElement.setOpeningSize(2 * (rectangle.height / 2 - n2));
                    this.activeElement.setX(n, rectangle);
                    this.activeElement.setY(n2, rectangle);
                    this.repaint();
                }
                if (this.activeElement.getType() == "aperature" && this.isInsideOpticElement == 3) {
                    this.activeElement.setOpeningSize(2 * (n2 - rectangle.height / 2));
                    this.activeElement.setX(n, rectangle);
                    this.activeElement.setY(n2, rectangle);
                    this.repaint();
                }
            }
            if (this.activeElement.getPropertyDrag()) {
                if (this.isInsideOpticElement == 2 && (this.activeElement.getType() == "lens" || this.activeElement.getType() == "mirror")) {
                    this.activeElement.setFocalLength(n - this.activeElement.getX(), rectangle);
                    this.repaint();
                }
                if (this.isInsideOpticElement == 3 && (this.activeElement.getType() == "lens" || this.activeElement.getType() == "mirror")) {
                    this.activeElement.setFocalLength(-(n - this.activeElement.getX()), rectangle);
                    this.repaint();
                }
                if (this.isInsideOpticElement == 2 && this.activeElement.getType() == "dielectric") {
                    this.activeElement.setRadius(n - this.activeElement.getX(), rectangle);
                    ((Dielectric)this.activeElement).setDelN(-((double)n2 - (double)rectangle.height / 2.0) / (double)50);
                    this.recalculateIndexOfRefraction();
                    this.repaint();
                }
                if (this.isInsideOpticElement == 3 && this.activeElement.getType() == "dielectric") {
                    this.activeElement.setRadius(-(n - this.activeElement.getX()), rectangle);
                    ((Dielectric)this.activeElement).setDelN(-((double)n2 - (double)rectangle.height / 2.0) / (double)50);
                    this.recalculateIndexOfRefraction();
                    this.repaint();
                }
                if (this.isInsideOpticElement == 1 && this.isControlDown && this.activeElement.getType() == "source") {
                    this.activeElement.setRayIncrement(1.0 - (double)(n - this.activeElement.getX()) * 0.005);
                    if (n <= this.activeElement.getX() + 15) {
                        this.activeElement.setRayIncrement(1.0);
                    }
                    if (n - this.activeElement.getX() < 0) {
                        this.activeElement.setRayIncrement(3.0);
                    }
                    this.repaint();
                }
                if (this.isInsideOpticElement == 2 && this.activeElement.getType() == "source") {
                    this.activeElement.setRaySlope(1.0 * (double)(n2 - this.activeElement.getY()) / (double)(n - this.activeElement.getX()));
                    if (this.activeElement.getX() > n) {
                        this.activeElement.setDirection(-1);
                    } else {
                        this.activeElement.setDirection(1);
                    }
                    this.repaint();
                }
                if (this.isInsideOpticElement == 1 && this.isControlDown && this.activeElement.getType() == "isource") {
                    this.activeElement.setSpread(100 + (this.activeElement.getY() - n2));
                    this.activeElement.setSpacing(10 + (this.activeElement.getX() - n));
                    this.repaint();
                }
                if (this.isInsideOpticElement == 2 && this.activeElement.getType() == "isource") {
                    this.activeElement.setAngle((1.0 * (double)this.activeElement.getY() - (double)n2) / (double)(1 * (this.activeElement.getX() - n)));
                    if (this.activeElement.getX() > n) {
                        this.activeElement.setDirection(-1);
                    } else {
                        this.activeElement.setDirection(1);
                    }
                    this.repaint();
                }
            }
        } else {
            this.drawAngle(n, n2);
        }
    }

    public void mouseMoved(int n, int n2) {
        Object object;
        Rectangle rectangle = this.getBounds();
        this.i = 0;
        while (this.i < this.v.size()) {
            object = (OpticElement)this.v.elementAt(this.i);
            if (((OpticElement)object).isInside(n, n2, rectangle) == 1 || ((OpticElement)object).isInside(n, n2, rectangle) == 2 || ((OpticElement)object).isInside(n, n2, rectangle) == 3) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.isInsideOpticElement = ((OpticElement)object).isInside(n, n2, rectangle);
                break;
            }
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.isInsideOpticElement = 0;
            ++this.i;
        }
        if (this.isInsideOpticElement == 0) {
            this.i = 0;
            while (this.i < this.sv.size()) {
                object = (OpticElement)this.sv.elementAt(this.i);
                if (((OpticElement)object).isInside(n, n2, rectangle) == 1 || ((OpticElement)object).isInside(n, n2, rectangle) == 2) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    this.isInsideOpticElement = ((OpticElement)object).isInside(n, n2, rectangle);
                    break;
                }
                this.setCursor(Cursor.getPredefinedCursor(1));
                this.isInsideOpticElement = 0;
                ++this.i;
            }
        }
        object = this.getGraphics();
        this.drawCoords((Graphics)object, n, n2);
        ((Graphics)object).dispose();
    }

    public void drawCoords(Graphics graphics, int n, int n2) {
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        graphics.fillRect(0, rectangle.height - 20, 100, 20);
        graphics.setColor(Color.black);
        graphics.drawString(String.valueOf(String.valueOf(String.valueOf("").concat(String.valueOf(this.df.format(1.0 * (double)n / (double)this.pixPerUnit)))).concat(String.valueOf(" , "))).concat(String.valueOf(this.df.format(1.0 * (double)rectangle.height / (double)2 / (double)this.pixPerUnit - 1.0 * (double)n2 / (double)this.pixPerUnit))), 10, rectangle.height - 5);
    }

    public void drawAngle(int n, int n2) {
        Graphics graphics = this.getGraphics();
        double d = n - this.xDown;
        double d2 = -n2 + this.yDown;
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.white);
        graphics.setXORMode(Color.red);
        graphics.drawLine(this.xDown, this.yDown, this.xLast, this.yLast);
        graphics.drawLine(this.xDown, this.yDown, n, n2);
        this.xLast = n;
        this.yLast = n2;
        graphics.setPaintMode();
        graphics.setColor(Color.yellow);
        graphics.drawLine(this.xDown, this.yDown, this.xDown + 30, this.yDown);
        graphics.fillRect(0, rectangle.height - 20, 100, 20);
        graphics.setColor(Color.black);
        graphics.drawString(String.valueOf("Angle:").concat(String.valueOf((int)((double)180 * Math.atan2(d2, d) / Math.PI))), 10, rectangle.height - 5);
        graphics.dispose();
    }
}

