/*
 * Decompiled with CFR 0.152.
 */
package optics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import optics.Source;

public final class ISource
extends Source {
    int spread;
    int spacing;
    double angle;

    public ISource(int n, int n2, int n3, double d, boolean bl, boolean bl2, int n4, boolean bl3) {
        this.propertyDrag = bl3;
        this.info = bl;
        this.drag = bl2;
        this.direction = n4;
        this.xPosition = n;
        this.yPosition = n2;
        this.spread = n3;
        this.spacing = 10;
        this.angle = d;
        this.mat[0][0] = 1.0;
        this.mat[0][1] = 0.0;
        this.mat[1][0] = 0.0;
        this.mat[1][1] = 1.0;
    }

    public int isInside(int n, int n2, Rectangle rectangle) {
        if (n > this.xPosition - 10 && n < this.xPosition + 10 && n2 > this.yPosition - 50 && n2 < this.yPosition + 50) {
            return 1;
        }
        if (this.propertyDrag && n > this.xPosition + this.direction * 40 - 10 && n < this.xPosition + this.direction * 40 + 10 && (double)n2 > (double)this.yPosition + this.angle * (double)(this.direction * 40) - (double)10 && (double)n2 < (double)this.yPosition + this.angle * (double)(this.direction * 40) + (double)10) {
            return 2;
        }
        return 0;
    }

    public int getSpread() {
        return this.spread;
    }

    public void setSpread(int n) {
        this.spread = n < 1 ? 1 : n;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        this.spacing = n < 1 ? 1 : n;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d < (double)-1 ? -1.0 : (d > 1.0 ? 1.0 : d);
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        if (this.elementColor == null) {
            graphics.setColor(Color.green);
        } else {
            graphics.setColor(this.elementColor);
        }
        graphics.drawOval(this.xPosition - 10, this.yPosition - this.spread / 2, 20, this.spread);
    }

    public void paintActive(Graphics graphics, Rectangle rectangle) {
        if (this.drag) {
            graphics.setColor(Color.white);
            graphics.fillOval(this.xPosition - 3, this.yPosition - 3, 6, 6);
        }
        if (this.propertyDrag) {
            graphics.fillOval(this.xPosition + this.direction * 40 - 3, this.yPosition + (int)(this.angle * (double)(this.direction * 40)) - 3, 6, 6);
        }
        if (this.info) {
            graphics.setColor(Color.white);
            graphics.drawString(String.valueOf(String.valueOf(String.valueOf("x = ").concat(String.valueOf(this.df.format(1.0 * (double)this.xPosition / (double)this.pixPerUnit)))).concat(String.valueOf(" , y ="))).concat(String.valueOf(this.df.format(1.0 * (double)rectangle.height / (double)2 / (double)this.pixPerUnit - 1.0 * (double)this.yPosition / (double)this.pixPerUnit))), this.xPosition, rectangle.height - 90);
            graphics.drawString(String.valueOf("spacing = ").concat(String.valueOf(this.df.format(1.0 * (double)this.spacing / (double)this.pixPerUnit))), this.xPosition, rectangle.height - 70);
            graphics.drawString(String.valueOf("spread = ").concat(String.valueOf(this.df.format(1.0 * (double)this.spread / (double)this.pixPerUnit))), this.xPosition, rectangle.height - 50);
            graphics.drawString(String.valueOf("angle = ").concat(String.valueOf(this.df.format(this.angle))), this.xPosition, rectangle.height - 30);
        }
    }

    public String getType() {
        return "isource";
    }
}

