/*
 * Decompiled with CFR 0.152.
 */
package optics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import optics.OpticElement;

public final class Lens
extends OpticElement {
    double indexOfGlass = 1.8;
    int curvatureFactor;
    int radius;
    private Polygon outline = new Polygon();
    private int iheight = 0;

    public Lens() {
    }

    public Lens(int n, int n2, double d, boolean bl, boolean bl2, double d2, boolean bl3) {
        this.info = bl;
        this.drag = bl2;
        this.size = d2;
        this.propertyDrag = bl3;
        this.curvatureFactor = 3;
        this.xPosition = n;
        this.yPosition = n2;
        this.focalLength = d;
        this.mat[0][0] = 1.0;
        this.mat[0][1] = 0.0;
        this.mat[1][0] = this.focalLength == 0.0 ? 0.0 : (double)-1 / this.focalLength;
        this.mat[1][1] = 1.0;
    }

    private void makeOutline(int n) {
        if (this.focalLength == 0.0) {
            this.makeOutlineZero(n);
        } else if (this.focalLength < 0.0) {
            this.makeOutlineMinus(n);
        } else {
            this.makeOutlinePlus(n);
        }
    }

    private void makeOutlineZero(int n) {
        this.iheight = n;
        n = (int)((double)n * this.size);
        this.outline = new Polygon();
        int n2 = this.xPosition;
        int n3 = 0;
        this.outline.addPoint(n2, n3);
        n2 = this.xPosition;
        n3 = this.iheight;
        this.outline.addPoint(n2, n3);
    }

    private void makeOutlinePlus(int n) {
        double d;
        this.iheight = n;
        n = (int)((double)n * this.size);
        this.outline = new Polygon();
        this.radius = (int)(1.5 * (double)n + Math.abs((double)2 * this.focalLength));
        double d2 = d / (double)50;
        double d3 = (double)this.radius * Math.cos(d);
        for (double d4 = d = Math.asin((double)n / (double)this.radius / 2.0); d4 > -d; d4 -= d2) {
            int n2 = (int)((double)this.xPosition - d3 + (double)this.radius * Math.cos(d4) + (double)3);
            int n3 = (int)((double)this.radius * Math.sin(d4) + (double)(this.iheight / 2));
            this.outline.addPoint(n2, n3);
        }
        for (int i = this.outline.npoints - 1; i >= 0; --i) {
            this.outline.addPoint(2 * this.xPosition - this.outline.xpoints[i], this.outline.ypoints[i]);
        }
    }

    private void makeOutlineMinus(int n) {
        double d;
        double d2;
        this.iheight = n;
        n = (int)((double)n * this.size);
        this.outline = new Polygon();
        this.radius = (int)(1.5 * (double)n + Math.abs((double)2 * this.focalLength));
        double d3 = d2 / (double)50;
        double d4 = (double)this.radius * Math.cos(d2);
        double d5 = (double)this.radius - d4;
        int n2 = this.xPosition;
        int n3 = (int)((double)this.radius * Math.sin(d) + (double)(this.iheight / 2));
        this.outline.addPoint(n2, n3);
        for (d = d2 = Math.asin((double)n / (double)this.radius / 2.0); d > -d2; d -= d3) {
            n2 = (int)((double)this.xPosition - d4 + (double)this.radius * Math.cos(d) - d5 - (double)4);
            n3 = (int)((double)this.radius * Math.sin(d) + (double)(this.iheight / 2));
            this.outline.addPoint(n2, n3);
        }
        n2 = this.xPosition;
        n3 = (int)((double)this.radius * Math.sin(d) + (double)(this.iheight / 2) + (double)2);
        this.outline.addPoint(n2, n3);
        for (int i = this.outline.npoints - 1; i >= 0; --i) {
            this.outline.addPoint(2 * this.xPosition - this.outline.xpoints[i], this.outline.ypoints[i]);
        }
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        if (rectangle.height != this.iheight) {
            this.makeOutline(rectangle.height);
        }
        graphics.setColor(Color.lightGray);
        graphics.fillPolygon(this.outline);
        if (this.elementColor == null) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(this.elementColor);
        }
        graphics.drawPolygon(this.outline);
        graphics.drawLine(this.xPosition, (int)((double)rectangle.height * (1.0 - this.size) / 2.0), this.xPosition, 0);
        graphics.drawLine(this.xPosition, (int)((double)rectangle.height * (1.0 + this.size) / 2.0), this.xPosition, rectangle.height);
    }

    public void paintActive(Graphics graphics, Rectangle rectangle) {
        int n = (int)this.focalLength;
        if (Math.abs(this.focalLength) < (double)2) {
            n = 20;
        }
        if (this.drag) {
            graphics.setColor(Color.blue);
            graphics.drawLine(this.xPosition, 0, this.xPosition, rectangle.height);
            graphics.setColor(Color.white);
            graphics.drawLine(this.xPosition + n, rectangle.height / 2 - 15, this.xPosition + n, rectangle.height / 2 + 15);
            graphics.drawLine(this.xPosition - n, rectangle.height / 2 - 15, this.xPosition - n, rectangle.height / 2 + 15);
            graphics.fillOval(this.xPosition - n - 3, rectangle.height / 2 - 3, 6, 6);
            graphics.fillOval(this.xPosition + n - 3, rectangle.height / 2 - 3, 6, 6);
        }
        if (this.info) {
            graphics.setColor(Color.white);
            graphics.drawString(String.valueOf("x = ").concat(String.valueOf(this.df.format(1.0 * (double)this.xPosition / (double)this.pixPerUnit))), this.xPosition, rectangle.height - 50);
            graphics.drawString(String.valueOf("fl = ").concat(String.valueOf(this.df.format(1.0 * this.focalLength / (double)this.pixPerUnit))), this.xPosition, rectangle.height - 30);
        }
    }

    public int isInside(int n, int n2, Rectangle rectangle) {
        int n3 = (int)this.focalLength;
        if (Math.abs(this.focalLength) < (double)2) {
            n3 = 20;
        }
        if (this.propertyDrag && n > this.xPosition + n3 - 5 && n < this.xPosition + n3 + 5 && n2 < rectangle.height / 2 + 15 && n2 > rectangle.height / 2 - 15) {
            return 2;
        }
        if (this.propertyDrag && n > this.xPosition - n3 - 10 && n < this.xPosition - n3 + 10 && n2 < rectangle.height / 2 + 15 && n2 > rectangle.height / 2 - 15) {
            return 3;
        }
        if (this.drag && n > this.xPosition - 10 && n < this.xPosition + 10) {
            return 1;
        }
        return 0;
    }

    public String getType() {
        return "lens";
    }

    public void setFocalLength(double d, Rectangle rectangle) {
        if (d != this.focalLength) {
            this.focalLength = d;
            if (Math.abs(d) < (double)2) {
                this.focalLength = 0.0;
                this.mat[1][0] = 0.0;
            } else {
                this.mat[1][0] = (double)-1 / this.focalLength;
            }
            this.makeOutline(this.iheight);
        }
    }

    public void setX(int n, Rectangle rectangle) {
        super.setX(n, rectangle);
        this.makeOutline(this.iheight);
    }

    public double getFocalLength() {
        return this.focalLength;
    }

    public int getWidth() {
        return 0;
    }

    public double[] transform(double[] dArray, Rectangle rectangle, int n) {
        double d = (this.indexOfGlass - this.indexOfRefraction) / (this.indexOfGlass - 1.0);
        double d2 = dArray[0] - (double)(rectangle.height / 2);
        dArray[1] = (double)n * (d * d2 * this.mat[1][0] + dArray[1]);
        return dArray;
    }
}

