/*
 * Decompiled with CFR 0.152.
 */
package optics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.DecimalFormat;

public class OpticElement {
    double focalLength;
    int errCode = 0;
    private Color rayColor = new Color(255, 255, 191);
    Color elementColor = null;
    private int nextElement = 0;
    private boolean clipOn = false;
    boolean drawDashedRay;
    boolean drawPRay;
    boolean drawSourceRay;
    int pixPerUnit = 1;
    int xPosition;
    int yPosition;
    boolean info;
    boolean drag;
    boolean propertyDrag;
    double size;
    double indexOfRefraction = 1.0;
    double[][] mat = new double[2][2];
    DecimalFormat df = new DecimalFormat("0.##");

    public OpticElement() {
        this.mat[0][0] = 1.0;
        this.mat[0][1] = 0.0;
        this.mat[1][0] = 0.0;
        this.mat[1][1] = 1.0;
    }

    public void setPixPerUnit(int n) {
        this.pixPerUnit = n;
    }

    public void paintTempActive(Graphics graphics, Rectangle rectangle) {
    }

    public void paintTemp(Graphics graphics, Rectangle rectangle) {
    }

    public void setInfo(boolean bl) {
        this.info = bl;
    }

    public void setDrag(boolean bl) {
        this.drag = bl;
    }

    public void setPropertyDrag(boolean bl) {
        this.propertyDrag = bl;
    }

    public boolean getInfo() {
        return this.info;
    }

    public boolean getDrag() {
        return this.drag;
    }

    public boolean getPropertyDrag() {
        return this.propertyDrag;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public double getSize() {
        return this.size;
    }

    public int isInside(int n, int n2, Rectangle rectangle) {
        if (n > this.xPosition - 10 && n < this.xPosition + 10) {
            return 1;
        }
        return 0;
    }

    public double[] transform(double[] dArray, Rectangle rectangle, int n) {
        double d = dArray[0] - (double)(rectangle.height / 2);
        dArray[0] = dArray[0] * this.mat[0][0] + dArray[1] * this.mat[0][1];
        dArray[1] = (double)n * (d * this.mat[1][0] + dArray[1] * this.mat[1][1]);
        return dArray;
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.white);
        graphics.drawLine(this.xPosition, 0, this.xPosition, rectangle.height);
    }

    public void paintActive(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.green);
        graphics.drawLine(this.xPosition, 0, this.xPosition, rectangle.height);
    }

    public void setX(int n, Rectangle rectangle) {
        this.xPosition = n < 1 ? 1 : (n > rectangle.width - 1 ? rectangle.width - 1 : n);
    }

    public void setY(int n, Rectangle rectangle) {
        this.yPosition = n < 1 ? 1 : (n > rectangle.height - 1 ? rectangle.height - 1 : n);
    }

    public int getX() {
        return this.xPosition;
    }

    public int getY() {
        return this.yPosition;
    }

    public double getTheta() {
        return 0.0;
    }

    public int getSpread() {
        return 0;
    }

    public void setSpread(int n) {
    }

    public double getAngle() {
        return 0.0;
    }

    public void setAngle(double d) {
    }

    public int getSpacing() {
        return 0;
    }

    public void setSpacing(int n) {
    }

    public final Color getRayColor() {
        return this.rayColor;
    }

    public final void setRayColor(Color color) {
        this.rayColor = color;
    }

    public final void setElementColor(Color color) {
        this.elementColor = color;
    }

    public void setRayIncrement(double d) {
    }

    public double getRayIncrement() {
        return 0.0;
    }

    public void setRaySlope(double d) {
    }

    public double getRaySlope() {
        return 0.0;
    }

    public String getType() {
        return "optic element";
    }

    public void setFocalLength(double d, Rectangle rectangle) {
    }

    public void setOpeningSize(int n) {
    }

    public int getOpeningSize() {
        return 0;
    }

    public double getFocalLength() {
        return 0.0;
    }

    public int getWidth() {
        return 0;
    }

    public void setRadius(int n, Rectangle rectangle) {
    }

    public int getR() {
        return 0;
    }

    public void setDirection(int n) {
    }

    public int getDirection() {
        return 0;
    }

    public final void setNextElement(int n) {
        this.nextElement = n;
    }

    public final int getNextElement() {
        return this.nextElement;
    }

    public final void setClipOn(boolean bl) {
        this.clipOn = bl;
    }

    public final boolean getClipOn() {
        return this.clipOn;
    }
}

