/*
 * Decompiled with CFR 0.152.
 */
package optics;

import borland.jbcl.control.BevelPanel;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import optics.Bench;
import optics.OpticsApplet_aperatureBtn_actionAdapter;
import optics.OpticsApplet_bench_keyAdapter;
import optics.OpticsApplet_bench_mouseAdapter;
import optics.OpticsApplet_bench_mouseMotionAdapter;
import optics.OpticsApplet_bevelPanel1_mouseAdapter;
import optics.OpticsApplet_clearActiveElementBtn_actionAdapter;
import optics.OpticsApplet_clearBtn_actionAdapter;
import optics.OpticsApplet_isourceBtn_actionAdapter;
import optics.OpticsApplet_lensBtn_actionAdapter;
import optics.OpticsApplet_mirrorBtn_actionAdapter;
import optics.OpticsApplet_psourceBtn_actionAdapter;
import optics.OpticsApplet_sourceBtn_actionAdapter;

public class OpticsApplet
extends Applet {
    private boolean showControls = true;
    private boolean clipOn = true;
    boolean info = true;
    boolean drag = true;
    boolean propertyDrag = true;
    double size = 0.5;
    int direction = 1;
    int pixPerUnit;
    boolean isStandalone = false;
    String example;
    String opticString = null;
    BevelPanel bevelPanel1 = new BevelPanel();
    Button lensBtn = new Button();
    Button sourceBtn = new Button();
    Bench bench = new Bench();
    BevelPanel bevelPanel2 = new BevelPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    Button clearBtn = new Button();
    BorderLayout borderLayout1 = new BorderLayout();
    Button psourceBtn = new Button();
    int defaultFocalLength = 50;
    int defaultOpeningSize = 100;
    double defaultDelN = 1.4;
    int defaultR = -50;
    Button isourceBtn = new Button();
    BevelPanel bevelPanel3 = new BevelPanel();
    Button aperatureBtn = new Button();
    Button clearActiveElementBtn = new Button();
    Button mirrorBtn = new Button();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (this.getParameter(string) != null ? this.getParameter(string) : string2);
    }

    public void init() {
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.showControls) {
            this.setUnDefault();
        } else {
            this.setDefault();
        }
        this.bench.repaint();
    }

    public void jbInit() throws Exception {
        this.bevelPanel1.setLayout(this.flowLayout2);
        this.setSize(new Dimension(437, 426));
        this.bevelPanel1.addMouseListener(new OpticsApplet_bevelPanel1_mouseAdapter(this));
        this.lensBtn.setLabel("  Lens  ");
        this.lensBtn.addActionListener(new OpticsApplet_lensBtn_actionAdapter(this));
        this.sourceBtn.setLabel(" Source ");
        this.sourceBtn.addActionListener(new OpticsApplet_sourceBtn_actionAdapter(this));
        this.bench.addKeyListener(new OpticsApplet_bench_keyAdapter(this));
        this.bench.addMouseMotionListener(new OpticsApplet_bench_mouseMotionAdapter(this));
        this.clearBtn.setLabel("Clear All");
        this.psourceBtn.setLabel(" Object ");
        this.isourceBtn.setActionCommand("Add ISource");
        this.aperatureBtn.setActionCommand("aperatureBtn");
        this.clearActiveElementBtn.setLabel("Clear Active");
        this.clearActiveElementBtn.setActionCommand("clearActiveElementBtn");
        this.mirrorBtn.setActionCommand("mirrorBtn");
        this.mirrorBtn.addActionListener(new OpticsApplet_mirrorBtn_actionAdapter(this));
        this.mirrorBtn.setLabel(" Mirror ");
        this.clearActiveElementBtn.addActionListener(new OpticsApplet_clearActiveElementBtn_actionAdapter(this));
        this.aperatureBtn.addActionListener(new OpticsApplet_aperatureBtn_actionAdapter(this));
        this.aperatureBtn.setLabel("Aperature");
        this.bevelPanel3.setLayout(this.flowLayout1);
        this.isourceBtn.addActionListener(new OpticsApplet_isourceBtn_actionAdapter(this));
        this.isourceBtn.setLabel("  Beam  ");
        this.psourceBtn.addActionListener(new OpticsApplet_psourceBtn_actionAdapter(this));
        this.clearBtn.addActionListener(new OpticsApplet_clearBtn_actionAdapter(this));
        this.bevelPanel2.setLayout(this.borderLayout2);
        this.bench.addMouseListener(new OpticsApplet_bench_mouseAdapter(this));
        this.setLayout(this.borderLayout1);
        this.bench.repaint();
        if (this.showControls) {
            this.add((Component)this.bevelPanel1, "South");
        }
        this.bevelPanel1.add((Component)this.lensBtn, null);
        this.bevelPanel1.add((Component)this.mirrorBtn, null);
        this.bevelPanel1.add((Component)this.aperatureBtn, null);
        this.bevelPanel1.add((Component)this.clearActiveElementBtn, null);
        this.add((Component)this.bevelPanel2, "Center");
        this.bevelPanel2.add((Component)this.bench, "Center");
        if (this.showControls) {
            this.add((Component)this.bevelPanel3, "North");
        }
        this.bevelPanel3.add((Component)this.isourceBtn, null);
        this.bevelPanel3.add((Component)this.psourceBtn, null);
        this.bevelPanel3.add((Component)this.sourceBtn, null);
        this.bevelPanel3.add((Component)this.clearBtn, null);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"example", "String", "an example parameter"}};
        return stringArray;
    }

    public void clearAll() {
        this.bench.clearOptics();
        this.bench.repaint();
    }

    public void setDrag(boolean bl) {
        this.drag = bl;
    }

    public void setPropertyDrag(boolean bl) {
        this.propertyDrag = bl;
    }

    public void setInfo(boolean bl) {
        this.info = bl;
    }

    public void setElementRGB(int n, int n2, int n3) {
        if (n == 0 && n2 == 0 && n3 == 0) {
            this.bench.setElementColor(null);
        } else {
            this.bench.setElementColor(new Color(n, n2, n3));
        }
    }

    public void setRayRGB(int n, int n2, int n3) {
        this.bench.setRayColor(new Color(n, n2, n3));
    }

    public void setSize(double d) {
        this.size = d;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void setPixPerUnit(int n) {
        this.pixPerUnit = n;
        this.bench.setPixPerUnit(n);
        this.bench.repaint();
    }

    public void setDefault() {
        this.clearAll();
        this.setPixPerUnit(100);
        this.setInfo(false);
        this.setSize(0.8);
        this.setDrag(false);
        this.setPropertyDrag(false);
        this.setDirection(1);
    }

    public void setUnDefault() {
        this.clearAll();
        this.setPixPerUnit(100);
        this.setInfo(true);
        this.setSize(0.8);
        this.setDrag(true);
        this.setPropertyDrag(true);
        this.setDirection(1);
    }

    void lensBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.lensBtn.getForeground() == Color.blue) {
            this.setNull();
        } else {
            this.opticString = "lens";
            this.setBtnOff();
            this.lensBtn.setForeground(Color.blue);
        }
    }

    void sourceBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.sourceBtn.getForeground() == Color.red) {
            this.setNull();
        } else {
            this.opticString = "source";
            this.setBtnOff();
            this.sourceBtn.setForeground(Color.red);
        }
    }

    public void addAperture(double d, double d2) {
        this.addAperature(d, d2);
    }

    private void addAperature(double d, double d2) {
        this.bench.addAperature((int)(d * (double)this.pixPerUnit), 0, (int)(d2 * (double)this.pixPerUnit), this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addDielectric(double d, double d2, double d3) {
        this.bench.addDielectric((int)(d * (double)this.pixPerUnit), 0, d2, (int)(d3 * (double)this.pixPerUnit), this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addIndexChange(double d, double d2) {
        this.bench.addIndexChange((int)(d * (double)this.pixPerUnit), 0, d2, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addRefraction(double d, double d2, double d3) {
        this.bench.addRefraction((int)(d * (double)this.pixPerUnit), 0, d2, (int)(d3 * (double)this.pixPerUnit), this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addISource(double d, double d2, int n, double d3) {
        Rectangle rectangle = this.bench.getBounds();
        this.bench.addISource((int)(d * (double)this.pixPerUnit), (int)((double)rectangle.height / 2.0 - d2 * (double)this.pixPerUnit), n, d3, this.info, this.drag, this.direction, this.propertyDrag);
        this.bench.repaint();
    }

    public void addLens(double d, double d2) {
        this.bench.addLens((int)(d * (double)this.pixPerUnit), 0, d2 * (double)this.pixPerUnit, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addMirror(double d, double d2) {
        this.bench.addMirror((int)(d * (double)this.pixPerUnit), 0, d2 * (double)this.pixPerUnit, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addSphericalMirror(double d, double d2) {
        this.bench.addSphericalMirror((int)(d * (double)this.pixPerUnit), 0, d2 * (double)this.pixPerUnit, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addPSource(double d, double d2) {
        Rectangle rectangle = this.bench.getBounds();
        this.bench.addPSource((int)(d * (double)this.pixPerUnit), (int)((double)rectangle.height / 2.0 - d2 * (double)this.pixPerUnit), this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addScreen(double d) {
        this.bench.addScreen((int)(d * (double)this.pixPerUnit), 0, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addSource(double d, double d2, double d3, double d4) {
        Rectangle rectangle = this.bench.getBounds();
        this.bench.addSource((int)(d * (double)this.pixPerUnit), (int)((double)rectangle.height / 2.0 - d2 * (double)this.pixPerUnit), d3, d4, this.info, this.drag, this.direction, this.propertyDrag);
        this.bench.repaint();
    }

    public void addApertureP(int n, int n2) {
        this.addAperatureP(n, n2);
    }

    private void addAperatureP(int n, int n2) {
        this.bench.addAperature(n, 0, n2, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addDielectricP(int n, double d, int n2) {
        this.bench.addDielectric(n, 0, d, n2, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addIndexChangeP(int n, double d) {
        this.bench.addIndexChange(n, 0, d, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addRefractionP(int n, double d, int n2) {
        this.bench.addRefraction(n, 0, d, n2, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addISourceP(int n, int n2, int n3, double d) {
        Rectangle rectangle = this.bench.getBounds();
        this.bench.addISource(n, rectangle.height / 2 - n2, n3, d, this.info, this.drag, this.direction, this.propertyDrag);
        this.bench.repaint();
    }

    public void addLensP(int n, double d) {
        this.bench.addLens(n, 0, d, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addMirrorP(int n, double d) {
        this.bench.addMirror(n, 0, d, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addSphericalMirrorP(int n, double d) {
        this.bench.addSphericalMirror(n, 0, d, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addPSourceP(int n, int n2) {
        Rectangle rectangle = this.bench.getBounds();
        this.bench.addPSource(n, rectangle.height / 2 - n2, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addScreenP(int n) {
        this.bench.addScreen(n, 0, this.info, this.drag, this.size, this.propertyDrag);
        this.bench.repaint();
    }

    public void addSourceP(int n, int n2, double d, double d2) {
        Rectangle rectangle = this.bench.getBounds();
        this.bench.addSource(n, rectangle.height / 2 - n2, d, d2, this.info, this.drag, this.direction, this.propertyDrag);
        this.bench.repaint();
    }

    void bench_mousePressed(MouseEvent mouseEvent) {
        this.bench.isControlDown = mouseEvent.isControlDown();
        if (this.opticString == "lens") {
            this.bench.addLens(mouseEvent.getX(), mouseEvent.getY(), this.defaultFocalLength, this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "mirror") {
            this.bench.addMirror(mouseEvent.getX(), mouseEvent.getY(), this.defaultFocalLength, this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "source") {
            this.bench.addSource(mouseEvent.getX(), mouseEvent.getY(), 0.25, -1.0, this.info, this.drag, this.direction, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "psource") {
            this.bench.addPSource(mouseEvent.getX(), mouseEvent.getY(), this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "screen") {
            this.bench.addScreen(mouseEvent.getX(), mouseEvent.getY(), this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "isource") {
            this.bench.addISource(mouseEvent.getX(), mouseEvent.getY(), 100, 0.0, this.info, this.drag, this.direction, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "aperature") {
            this.bench.addAperature(mouseEvent.getX(), mouseEvent.getY(), this.defaultOpeningSize, this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "dielectric") {
            this.bench.addDielectric(mouseEvent.getX(), mouseEvent.getY(), this.defaultDelN, this.defaultR, this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == null) {
            this.bench.mousePressed(mouseEvent.getX(), mouseEvent.getY());
        }
        this.bench.repaint();
    }

    public void setNull() {
        this.opticString = null;
        this.setBtnOff();
    }

    void nullBtn_actionPerformed(ActionEvent actionEvent) {
        this.setNull();
    }

    void clearBtn_actionPerformed(ActionEvent actionEvent) {
        this.bench.clearOptics();
        this.bench.repaint();
    }

    void bench_mouseReleased(MouseEvent mouseEvent) {
        if (this.opticString == null) {
            this.bench.mouseReleased(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void bench_mouseDragged(MouseEvent mouseEvent) {
        if (this.opticString == null) {
            this.bench.mouseDragged(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void bench_mouseMoved(MouseEvent mouseEvent) {
        if (this.opticString == null) {
            this.bench.mouseMoved(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void psourceBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.psourceBtn.getForeground() == Color.red) {
            this.setNull();
        } else {
            this.opticString = "psource";
            this.setBtnOff();
            this.psourceBtn.setForeground(Color.red);
        }
    }

    void isourceBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.isourceBtn.getForeground() == Color.green) {
            this.setNull();
        } else {
            this.opticString = "isource";
            this.setBtnOff();
            this.isourceBtn.setForeground(Color.green);
        }
    }

    public void setBtnOff() {
        this.lensBtn.setForeground(new Color(0, 0, 0));
        this.sourceBtn.setForeground(new Color(0, 0, 0));
        this.psourceBtn.setForeground(new Color(0, 0, 0));
        this.isourceBtn.setForeground(new Color(0, 0, 0));
        this.aperatureBtn.setForeground(new Color(0, 0, 0));
        this.mirrorBtn.setForeground(new Color(0, 0, 0));
        this.repaint();
    }

    void aperatureBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.aperatureBtn.getForeground() == Color.yellow) {
            this.setNull();
        } else {
            this.opticString = "aperature";
            this.setBtnOff();
            this.aperatureBtn.setForeground(Color.yellow);
        }
    }

    void clearActiveElementBtn_actionPerformed(ActionEvent actionEvent) {
        this.bench.clearActiveElement();
    }

    void mirrorBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.mirrorBtn.getForeground() == Color.blue) {
            this.setNull();
        } else {
            this.opticString = "mirror";
            this.setBtnOff();
            this.mirrorBtn.setForeground(Color.blue);
        }
    }

    void buttonControl1_actionPerformed(ActionEvent actionEvent) {
        this.addSource(50.0, 50.0, 0.25, -1.0);
    }

    void bench_keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127 && this.showControls) {
            this.bench.clearActiveElement();
        }
    }
}

