(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     20349,        622]
NotebookOptionsPosition[     18734,        566]
NotebookOutlinePosition[     19090,        582]
CellTagsIndexPosition[     19047,        579]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["hydrogen atom Hamiltonian", "Text",
 CellChangeTimes->{{3.5310652541608887`*^9, 3.531065258471339*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["H", "l_"], "[", "f_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"-", 
      SuperscriptBox["\[HBar]", "2"]}], 
     RowBox[{"2", " ", "\[Micro]"}]], 
    RowBox[{"D", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "2"}], "}"}]}], "]"}]}], "+", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["\[HBar]", "2"], "l", 
      RowBox[{"(", 
       RowBox[{"l", "+", "1"}], ")"}]}], 
     RowBox[{"2", " ", "\[Micro]", " ", 
      SuperscriptBox["r", "2"]}]], "f"}], "-", 
   RowBox[{
    FractionBox[
     SuperscriptBox["e", "2"], "r"], "f"}]}]}]], "Input",
 CellChangeTimes->{{3.5310572173016148`*^9, 3.531057223133712*^9}, {
   3.531057523211954*^9, 3.531057672711502*^9}, {3.531057940725725*^9, 
   3.531057956441165*^9}, {3.5310580165158663`*^9, 3.531058026321733*^9}, 
   3.531058075655715*^9, {3.531058152844809*^9, 3.531058157963685*^9}}],

Cell["Schrodinger equation", "Text",
 CellChangeTimes->{{3.531065265503092*^9, 3.53106526985928*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sch", "[", "f_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    SubscriptBox["H", "l"], "@", "f"}], "\[Equal]", 
   RowBox[{"\[ScriptCapitalE]", " ", "f"}]}]}]], "Input",
 CellChangeTimes->{{3.5310577862234697`*^9, 3.531057853646624*^9}, {
  3.531058119548675*^9, 3.531058126627698*^9}, {3.531063030048678*^9, 
  3.53106304066971*^9}, {3.531830605095338*^9, 3.5318306096352463`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sch", "[", 
  RowBox[{"P0", "[", "r", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.531057896787301*^9, 3.531057919130958*^9}, {
  3.5310580879006*^9, 3.531058091676667*^9}, {3.53106575519829*^9, 
  3.531065755373846*^9}, {3.531067810999155*^9, 3.531067811270893*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["e", "2"], " ", 
      RowBox[{"P0", "[", "r", "]"}]}], "r"]}], "+", 
   FractionBox[
    RowBox[{"l", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "l"}], ")"}], " ", 
     SuperscriptBox["\[HBar]", "2"], " ", 
     RowBox[{"P0", "[", "r", "]"}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["r", "2"], " ", "\[Micro]"}]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[HBar]", "2"], " ", 
     RowBox[{
      SuperscriptBox["P0", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "r", "]"}]}], 
    RowBox[{"2", " ", "\[Micro]"}]]}], "\[Equal]", 
  RowBox[{"\[ScriptCapitalE]", " ", 
   RowBox[{"P0", "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{3.531058093100889*^9, 3.531058131414961*^9, 
  3.531058165778916*^9, 3.531065756373425*^9, 3.531067813405202*^9, 
  3.531068921231718*^9, 3.53106925799339*^9, 3.53183061569847*^9}]
}, Open  ]],

Cell[TextData[{
 "educated guess for the ground state wavefunctions for different ",
 StyleBox["l",
  FontSlant->"Italic"],
 "s"
}], "Text",
 CellChangeTimes->{{3.53106528327038*^9, 3.5310652971898327`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sch", "[", 
   RowBox[{
    SuperscriptBox["r", 
     RowBox[{"l", "+", "1"}]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "r"}], "/", "a"}]]}], "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.5310578571987762`*^9, 3.5310578654308987`*^9}, {
  3.531058174610153*^9, 3.531058175713419*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox["r", "a"]}]], " ", 
    SuperscriptBox["r", "l"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "l"}], ")"}], " ", 
       SuperscriptBox["\[HBar]", "2"]}], "+", 
      RowBox[{"r", " ", 
       SuperscriptBox["\[HBar]", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["e", "2"], "+", 
         RowBox[{"r", " ", "\[ScriptCapitalE]"}]}], ")"}], " ", 
       "\[Micro]"}]}], ")"}]}], 
   RowBox[{"a", " ", "\[Micro]"}]], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{
  3.531057868540495*^9, {3.531058106111312*^9, 3.531058134721683*^9}, {
   3.53105817066947*^9, 3.53105817689268*^9}, 3.531068933274822*^9, 
   3.531069258058729*^9, 3.531830626093355*^9}]
}, Open  ]],

Cell["\<\
to satisfy for all r, each power of r must separately vanish\
\>", "Text",
 CellChangeTimes->{{3.5310653217649193`*^9, 3.531065336388386*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "l"}], ")"}], " ", 
        SuperscriptBox["\[HBar]", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "\[Micro]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"r", " ", 
        SuperscriptBox["\[HBar]", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", "r", " ", "\[ScriptCapitalE]", " ", 
        "\[Micro]"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "\[ScriptCapitalE]"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.531058189692052*^9, 3.5310583127501307`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "l"}], ")"}], " ", 
       SuperscriptBox["\[HBar]", "2"]}], 
      RowBox[{
       SuperscriptBox["e", "2"], " ", "\[Micro]"}]]}], ",", 
    RowBox[{"\[ScriptCapitalE]", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "4"], " ", "\[Micro]"}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "l"}], ")"}], "2"], " ", 
        SuperscriptBox["\[HBar]", "2"]}]]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.53105823538589*^9, 3.531058315740258*^9, 
  3.531069102029426*^9, 3.5310692581175222`*^9, 3.531830631513667*^9}]
}, Open  ]],

Cell[TextData[{
 "so the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "r"], TraditionalForm]]],
 "=0 energy levels for arbitrary ",
 StyleBox["l ",
  FontSlant->"Italic"],
 " are"
}], "Text",
 CellChangeTimes->{{3.5310653414360733`*^9, 3.5310653555235853`*^9}, {
  3.5310678241016607`*^9, 3.531067827796904*^9}, {3.53183063783668*^9, 
  3.531830638136189*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"E0", "[", "l_", "]"}], ":=", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["e", "4"], " ", "\[Micro]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "l"}], ")"}], "2"], " ", 
     SuperscriptBox["\[HBar]", "2"]}]]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P0", "[", "l_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["r", 
     RowBox[{"l", "+", "1"}]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "r"}], "/", "a"}]]}], "/.", 
   RowBox[{"a", "\[Rule]", " ", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "l"}], ")"}], " ", 
      SuperscriptBox["\[HBar]", "2"]}], 
     RowBox[{
      SuperscriptBox["e", "2"], " ", "\[Micro]"}]]}]}]}]}], "Input",
 CellChangeTimes->{{3.531059127922761*^9, 3.5310591381598663`*^9}, {
  3.531063055967228*^9, 3.53106305615877*^9}, {3.531065737615795*^9, 
  3.531065787959198*^9}, {3.531067819961507*^9, 3.531067838752809*^9}}],

Cell["define \[OpenCurlyDoubleQuote]superpotential\[CloseCurlyDoubleQuote]", \
"Text",
 CellChangeTimes->{{3.531065359211412*^9, 3.531065366507409*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["W", "l_"], "[", "r", "]"}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"\[Micro]", " ", 
      SuperscriptBox["e", "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"l", "+", "1"}], ")"}], 
      SuperscriptBox["\[HBar]", "2"]}]], "-", 
    FractionBox[
     RowBox[{"l", "+", "1"}], "r"]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5310586338682947`*^9, 3.531058655547966*^9}, {
  3.531058686333897*^9, 3.53105871222978*^9}, {3.531058748668161*^9, 
  3.531058761715888*^9}, {3.531830662115361*^9, 3.531830664777547*^9}}],

Cell["\<\
define operators analogous to SHO raising and lowering operators\
\>", "Text",
 CellChangeTimes->{{3.531065385860626*^9, 3.531065410433916*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["A", "l_"], "[", "f_", "]"}], ":=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"f", ",", "r"}], "]"}], "+", 
   RowBox[{
    RowBox[{
     SubscriptBox["W", "l"], "[", "r", "]"}], "f"}]}]}]], "Input",
 CellChangeTimes->{{3.5310540168494883`*^9, 3.53105407939953*^9}, {
   3.531054546101636*^9, 3.531054546301588*^9}, {3.5310587723031797`*^9, 
   3.531058773347238*^9}, 3.531058913085836*^9, {3.531068099900654*^9, 
   3.531068106868415*^9}, {3.5310681461321917`*^9, 3.5310681465146227`*^9}, {
   3.5310691914188128`*^9, 3.531069191762423*^9}, {3.531830693986786*^9, 
   3.531830707799057*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["A\[Dagger]", "l_"], "[", "f_", "]"}], ":=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{"f", ",", "r"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{
     SubscriptBox["W", "l"], "[", "r", "]"}], "f"}]}]}]], "Input",
 CellChangeTimes->{{3.531054082426845*^9, 3.531054095952573*^9}, 
   3.531054304463217*^9, {3.5310545507455473`*^9, 3.531054551029249*^9}, 
   3.53105891672572*^9, {3.531068111868229*^9, 3.531068114387938*^9}, {
   3.5310681519627857`*^9, 3.53106815248242*^9}, {3.531069195050762*^9, 
   3.531069195306466*^9}, {3.531830715376155*^9, 3.531830727734309*^9}}],

Cell[TextData[{
 "Show that A\[Dagger]A and AA\[Dagger] are equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["H", "l"], "-", 
    RowBox[{
     SubscriptBox["E", 
      RowBox[{"0", "l"}]], "and", " "}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  RowBox[{
   SubscriptBox["H", 
    RowBox[{"l", "+", "1"}]], "-", 
   SubscriptBox["E", 
    RowBox[{"0", "l"}]]}]]],
 " "
}], "Text",
 CellChangeTimes->{{3.531065423728916*^9, 3.531065428176766*^9}, {
  3.531065475399105*^9, 3.531065591374545*^9}, {3.531065640329632*^9, 
  3.5310656406898317`*^9}, {3.531068032741466*^9, 3.531068038333673*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox[
      SuperscriptBox["\[HBar]", "2"], 
      RowBox[{"2", "\[Micro]"}]], 
     RowBox[{
      SubscriptBox["A\[Dagger]", "l"], "@", 
      RowBox[{
       SubscriptBox["A", "l"], "@", 
       RowBox[{"P", "[", "r", "]"}]}]}]}], "==", 
    RowBox[{
     RowBox[{
      SubscriptBox["H", "l"], "@", 
      RowBox[{"P", "[", "r", "]"}]}], "-", 
     RowBox[{
      RowBox[{"E0", "[", "l", "]"}], 
      RowBox[{"P", "[", "r", "]"}]}]}]}], ")"}], "//", "Simplify"}]], "Input",\

 CellChangeTimes->{{3.531058790234364*^9, 3.5310588809507008`*^9}, {
  3.531058919703926*^9, 3.5310589228299828`*^9}, {3.5310591458622723`*^9, 
  3.531059168204421*^9}, {3.5310592081560373`*^9, 3.5310593143265533`*^9}, {
  3.531059581702674*^9, 3.531059587437307*^9}, {3.531063062217061*^9, 
  3.531063062391472*^9}, {3.531068046592093*^9, 3.531068046855812*^9}, {
  3.5318307375711823`*^9, 3.531830769717342*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.5310588351413593`*^9, 3.5310588414197493`*^9}, 
   3.53105888299685*^9, 3.531058928633595*^9, {3.531059161399644*^9, 
   3.5310591696830997`*^9}, {3.531059262774441*^9, 3.531059315541215*^9}, 
   3.531059589667049*^9, 3.531067852443047*^9, 3.531068050759398*^9, 
   3.531068157673634*^9, 3.531069161345727*^9, 3.5310692001309566`*^9, 
   3.531069258395673*^9, {3.531830776303855*^9, 3.5318307968828907`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox[
      SuperscriptBox["\[HBar]", "2"], 
      RowBox[{"2", "\[Micro]"}]], 
     RowBox[{
      SubscriptBox["A", "l"], "@", 
      RowBox[{
       SubscriptBox["A\[Dagger]", "l"], "@", 
       RowBox[{"P", "[", "r", "]"}]}]}]}], "==", 
    RowBox[{
     RowBox[{
      SubscriptBox["H", 
       RowBox[{"l", "+", "1"}]], "@", 
      RowBox[{"P", "[", "r", "]"}]}], "-", 
     RowBox[{
      RowBox[{"E0", "[", "l", "]"}], 
      RowBox[{"P", "[", "r", "]"}]}]}]}], ")"}], "//", "Simplify"}]], "Input",\

 CellChangeTimes->{{3.531059343535287*^9, 3.531059366653841*^9}, {
  3.531059597286927*^9, 3.5310596038846684`*^9}, {3.531063067551816*^9, 
  3.531063068535344*^9}, {3.531068053463964*^9, 3.531068053719576*^9}, {
  3.5318308122794933`*^9, 3.5318308271472397`*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.531059348007803*^9, 3.5310593696120567`*^9}, 
   3.531059605407246*^9, 3.531063069242261*^9, 3.531067852528224*^9, 
   3.5310680543942213`*^9, 3.5310681609557133`*^9, 3.531069262887768*^9, 
   3.5318308292987328`*^9}]
}, Open  ]],

Cell["\<\
now in terms of the principal quantum number n:\
\>", "Text",
 CellChangeTimes->{{3.5310710041726103`*^9, 3.5310710166267776`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Enl", "[", 
   RowBox[{"n_", ",", "l_"}], "]"}], ":=", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["e", "4"], " ", "\[Micro]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox["\[HBar]", "2"]}]]}]}]], "Input",
 CellChangeTimes->{{3.531066356892103*^9, 3.531066407915106*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"P", "[", 
   RowBox[{"n_", ",", "l_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"P0l", "=", 
      RowBox[{"P0", "[", 
       RowBox[{"n", "-", "1"}], "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"P0l", "=", 
        RowBox[{
         SubscriptBox["A\[Dagger]", "lp"], "@", "P0l"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"lp", ",", 
         RowBox[{"n", "-", "2"}], ",", "l", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", "P0l"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.531065844329606*^9, 3.531065963423596*^9}, {
   3.531066115984953*^9, 3.531066118560648*^9}, {3.5310662601738577`*^9, 
   3.531066314201635*^9}, {3.5310665260657883`*^9, 3.531066526545656*^9}, {
   3.5310667428415117`*^9, 3.531066770832754*^9}, {3.531067775142049*^9, 
   3.531067795617445*^9}, 3.531067869966853*^9, {3.5310679483619328`*^9, 
   3.531068004458376*^9}, {3.531068222306281*^9, 3.531068272784154*^9}, {
   3.5310683050389*^9, 3.5310683161184273`*^9}, {3.5310685663250732`*^9, 
   3.531068567180559*^9}, {3.531068599284081*^9, 3.531068599475609*^9}, {
   3.531068676705042*^9, 3.531068678432534*^9}, {3.5310687259824657`*^9, 
   3.531068726526536*^9}, {3.531069314617466*^9, 3.531069333759467*^9}, {
   3.531069440541143*^9, 3.531069482872919*^9}, {3.531069895762693*^9, 
   3.5310698979770403`*^9}, {3.531070019053837*^9, 3.531070049291377*^9}, {
   3.53183090660396*^9, 3.531830920800703*^9}}],

Cell["\<\
verify that the wavefunctions satisfy the Schrodinger eqn, and print them \
out.  They are unnormalized.\
\>", "Text",
 CellChangeTimes->{{3.5310710381618767`*^9, 3.531071062185025*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "17"}], ",", 
     RowBox[{"l", "=", "10"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["H", "l"], "@", 
         RowBox[{"P", "[", 
          RowBox[{"n", ",", "l"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"Enl", "[", 
          RowBox[{"n", ",", "l"}], "]"}], 
         RowBox[{"P", "[", 
          RowBox[{"n", ",", "l"}], "]"}]}]}], ")"}], "//", "Simplify"}], 
     "]"}], ";", 
    RowBox[{
     RowBox[{
      RowBox[{"P", "[", 
       RowBox[{"n", ",", "l"}], "]"}], "/.", 
      RowBox[{"\[Micro]", "->", 
       FractionBox[
        RowBox[{" ", 
         SuperscriptBox["\[HBar]", "2"]}], 
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SubscriptBox["a", "B"]}]]}]}], "//", "Simplify"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.531070218954836*^9, 3.531070427190123*^9}, {
  3.5318309502845497`*^9, 3.531830953684376*^9}, {3.531830991447947*^9, 
  3.531830994118478*^9}, {3.531831108618224*^9, 3.531831122585556*^9}, {
  3.5318311541605167`*^9, 3.531831166527698*^9}}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{{3.531831109707761*^9, 3.531831126042141*^9}, {
  3.5318311610923634`*^9, 3.531831176571006*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"313788397", " ", 
    SubsuperscriptBox["a", "B", "6"]}]], 
  RowBox[{"899", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox["r", 
      RowBox[{"17", " ", 
       SubscriptBox["a", "B"]}]]}]], " ", 
   SuperscriptBox["r", "11"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["r", "6"]}], "-", 
     RowBox[{"2754", " ", 
      SuperscriptBox["r", "5"], " ", 
      SubscriptBox["a", "B"]}], "+", 
     RowBox[{"1521585", " ", 
      SuperscriptBox["r", "4"], " ", 
      SubsuperscriptBox["a", "B", "2"]}], "-", 
     RowBox[{"431115750", " ", 
      SuperscriptBox["r", "3"], " ", 
      SubsuperscriptBox["a", "B", "3"]}], "+", 
     RowBox[{"65960709750", " ", 
      SuperscriptBox["r", "2"], " ", 
      SubsuperscriptBox["a", "B", "4"]}], "-", 
     RowBox[{"5158127502450", " ", "r", " ", 
      SubsuperscriptBox["a", "B", "5"]}], "+", 
     RowBox[{"160761640493025", " ", 
      SubsuperscriptBox["a", "B", "6"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.531070303063387*^9, 3.531070312196927*^9}, {
   3.531070373204948*^9, 3.531070428063775*^9}, 3.53183097273492*^9, {
   3.5318311053332253`*^9, 3.531831126126979*^9}, {3.531831161124136*^9, 
   3.53183117680547*^9}}]
}, Open  ]]
},
WindowSize->{740, 867},
WindowMargins->{{36, Automatic}, {Automatic, 84}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (November 6, \
2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 109, 1, 26, "Text"],
Cell[669, 23, 962, 28, 53, "Input"],
Cell[1634, 53, 101, 1, 26, "Text"],
Cell[1738, 56, 412, 9, 27, "Input"],
Cell[CellGroupData[{
Cell[2175, 69, 292, 5, 27, "Input"],
Cell[2470, 76, 961, 27, 53, "Output"]
}, Open  ]],
Cell[3446, 106, 207, 6, 26, "Text"],
Cell[CellGroupData[{
Cell[3678, 116, 365, 10, 33, "Input"],
Cell[4046, 128, 974, 28, 61, "Output"]
}, Open  ]],
Cell[5035, 159, 152, 3, 26, "Text"],
Cell[CellGroupData[{
Cell[5212, 166, 849, 24, 33, "Input"],
Cell[6064, 192, 791, 23, 53, "Output"]
}, Open  ]],
Cell[6870, 218, 365, 12, 26, "Text"],
Cell[7238, 232, 1040, 31, 98, "Input"],
Cell[8281, 265, 152, 2, 26, "Text"],
Cell[8436, 269, 599, 17, 52, "Input"],
Cell[9038, 288, 154, 3, 26, "Text"],
Cell[9195, 293, 647, 15, 30, "Input"],
Cell[9845, 310, 642, 15, 30, "Input"],
Cell[10490, 327, 640, 20, 26, "Text"],
Cell[CellGroupData[{
Cell[11155, 351, 972, 26, 52, "Input"],
Cell[12130, 379, 462, 6, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12629, 390, 850, 25, 52, "Input"],
Cell[13482, 417, 271, 4, 27, "Output"]
}, Open  ]],
Cell[13768, 424, 141, 3, 26, "Text"],
Cell[13912, 429, 366, 11, 50, "Input"],
Cell[14281, 442, 1529, 33, 33, "Input"],
Cell[15813, 477, 196, 4, 26, "Text"],
Cell[CellGroupData[{
Cell[16034, 485, 1222, 37, 81, "Input"],
Cell[17259, 524, 147, 2, 20, "Print"],
Cell[17409, 528, 1309, 35, 107, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
